/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.fshows.fsframework.common.exception;

import java.io.Serializable;
import java.text.MessageFormat;

/**
 * 内部通用异常类
 *
 * @author wangyi
 * @version FsInternalException.java, v 0.1 2018-09-19 14:13 wangyi
 */
public class FsInternalException extends BaseException implements Serializable {

    private static final long serialVersionUID = -2525983584145264509L;

    /**
     * 项目Id
     */
    protected String projectId;

    /**
     * 业务类型
     */
    protected String businessType;

    /**
     * 异常信息
     */
    protected String msg;

    /**
     * 具体异常码
     */
    protected String code;

    /**
     * 子错误码
     */
    protected String subCode;

    /**
     * 异常构造器
     *
     * @param code      错误码
     * @param msgFormat 消息模板,内部会用MessageFormat拼接，模板类似：userid={0},message={1},date{2}
     * @param args      具体参数的值
     */
    public FsInternalException(String code, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    /**
     * 异常构造器
     *
     * @param code      错误码
     * @param subCode   子错误码
     * @param msgFormat 消息模板,内部会用MessageFormat拼接，模板类似：userid={0},message={1},date{2}
     * @param args      具体参数的值
     */
    public FsInternalException(String code, String subCode, String msgFormat, Object... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.subCode = subCode;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    public FsInternalException init(String projectId, String businessType) {
        FsInternalException exception = new FsInternalException();
        exception.setProjectId(projectId);
        exception.setBusinessType(businessType);
        return exception;
    }

    public FsInternalException build(String code, String subCode, String msgFormat, Object... args) {
        return new FsInternalException(this.code, this.subCode, MessageFormat.format(msgFormat, args));
    }

    /**
     * 实例化异常
     *
     * @param msgFormat
     * @param args
     * @return 异常类
     */
    @Override
    public FsInternalException newInstance(String msgFormat, Object... args) {
        this.msg = MessageFormat.format(msgFormat, args);
        return this;
    }

    /**
     * 默认构造器
     */
    public FsInternalException() {
        super();
    }

    /**
     * 异常构造器
     *
     * @param message
     * @param cause
     */
    public FsInternalException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * 异常构造器
     *
     * @param cause
     */
    public FsInternalException(Throwable cause) {
        super(cause);
    }

    /**
     * 异常构造器
     *
     * @param message
     */
    public FsInternalException(String message) {
        super(message);
    }

    /**
     * 子错误码
     *
     * @return
     */
    @Override
    public String getSubCode() { return subCode;}

    /**
     * 获取项目ID
     *
     * @return
     */
    public String getProjectId() {
        return projectId;
    }

    /**
     * 设置项目ID
     *
     * @param projectId
     */
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取业务类型
     *
     * @return
     */
    public String getBusinessType() {
        return businessType;
    }

    /**
     * 设置业务类型
     *
     * @param businessType
     */
    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    /**
     * 重写堆栈填充，不填充错误堆栈信息
     *
     * @return
     */
    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    /**
     * Returns the detail message string of this throwable.
     *
     * @return the detail message string of this {@code Throwable} instance
     * (which may be {@code null}).
     */
    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }
}


