/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fbank.sdk;

import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.com.fbank.openapi.sdk.client.FBankOpenApiClient;
import com.fshows.com.fbank.openapi.sdk.client.OpenParameters;
import com.fshows.com.fbank.openapi.sdk.config.Configuration;
import com.fshows.com.fbank.openapi.sdk.config.FileConfiguration;
import com.fshows.fbank.sdk.common.FBankApiEnum;
import com.fshows.fbank.sdk.common.FBankException;
import com.fshows.fbank.sdk.common.ReqIdUtil;
import com.fshows.fbank.sdk.common.ValidateUtil;
import com.fshows.fbank.sdk.request.FbankRequest;
import com.fshows.fbank.sdk.request.FileDownloadRequest;
import com.fshows.fbank.sdk.request.item.file.BizData;
import com.fshows.fbank.sdk.response.FbankResponse;
import com.fshows.fbank.sdk.response.FbankResponseBody;
import com.fshows.fbank.sdk.response.FbankResponseHead;
import java.lang.reflect.Type;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBankRequestClient
extends FBankOpenApiClient {
    private static final Logger log = LoggerFactory.getLogger(FBankRequestClient.class);
    public static final String REQUEST_SUCCESS_CODE = "000000";
    private static final String FILE_SEPARATOR = SystemUtil.getOsInfo().getFileSeparator();
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public FBankRequestClient(Configuration configuration) {
        super(configuration);
    }

    public <T extends FbankResponseBody> FbankResponse<T> request(FBankApiEnum apiEnum, FbankRequest request, Class<T> responseClass) throws FBankException {
        String reqId = ReqIdUtil.getId();
        log.info("request >> \u4f01\u5bcc\u901a\u8bf7\u6c42\u5f00\u59cb >>reqId = {}, apiEnum = {}, request = {}, responseClass = {}", new Object[]{reqId, apiEnum, request, responseClass});
        request.setMerchantNo(this.getConfiguration().merchantNo());
        request.setClientSerialNo(reqId);
        ValidateUtil.validateWithThrow(request, new Class[0]);
        OpenParameters context = new OpenParameters.Builder().apiName(apiEnum.getValue()).param(JSON.toJSONString((Object)request, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0])).build();
        try {
            String result = this.send(context);
            FbankResponse response = (FbankResponse)JSON.parseObject((String)result, (TypeReference)new TypeReference<FbankResponse<T>>(new Type[]{responseClass}){}, (Feature[])new Feature[0]);
            FbankResponseHead head = response.getHead();
            if (!StrUtil.equalsIgnoreCase((CharSequence)head.getRspCode(), (CharSequence)REQUEST_SUCCESS_CODE)) {
                log.error("request >> \u4f01\u5bcc\u901a\u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38 >> apiEnum = {}, request = {}", (Object)apiEnum, (Object)request);
                throw new FBankException(head.getRspCode(), head.getRspMsg(), new Object[0]).newInstance("\u8c03\u7528\u4f01\u5bcc\u901a\u63a5\u53e3\u4e1a\u52a1\u5f02\u5e38: code:{0}, msg:{1}", head.getRspCode(), head.getRspMsg());
            }
            log.info("request >> \u4f01\u5bcc\u901a\u8bf7\u6c42\u7ed3\u675f >>reqId = {}, apiEnum = {}, request = {}, responseClass = {}, result = {}", new Object[]{reqId, apiEnum, request, responseClass, result});
            return response;
        }
        catch (FBankException e) {
            log.error("request >> \u4f01\u5bcc\u901a\u8bf7\u6c42\u670d\u52a1\u4e1a\u52a1\u5f02\u5e38 >> apiEnum = {}, exception = {}, request = {}", new Object[]{apiEnum, ExceptionUtils.getStackTrace((Throwable)e), request});
            throw e;
        }
        catch (Exception e) {
            log.error("request >> \u4f01\u5bcc\u901a\u8bf7\u6c42\u670d\u52a1\u5f02\u5e38 >> apiEnum = {}, exception = {}, request = {}", new Object[]{apiEnum, ExceptionUtils.getStackTrace((Throwable)e), request});
            throw FBankException.SERVER_EXCEPTION;
        }
    }

    public String downloadFile(FileDownloadRequest request) {
        FBankApiEnum apiEnum = FBankApiEnum.FILE_DOWNLOAD;
        log.info("request >> \u4f01\u5bcc\u901a\u8bf7\u6c42\u5f00\u59cb >> apiEnum = {}, request = {}", (Object)apiEnum, (Object)request);
        BizData bizData = request.getBizData();
        bizData.setMerchantNo(this.getConfiguration().merchantNo());
        ValidateUtil.validateWithThrow(request, new Class[0]);
        String fileName = request.getFileName();
        OpenParameters context = new OpenParameters.Builder().apiName(apiEnum.getValue()).fileName(fileName).param(JSON.toJSONString((Object)request)).build();
        try {
            this.downloadFile(context);
            return ((FileConfiguration)this.getConfiguration()).storagePath() + FILE_SEPARATOR + fileName + "." + request.getFileType();
        }
        catch (Exception e) {
            log.error("request >> \u4f01\u5bcc\u901a\u4e0b\u8f7d\u6587\u4ef6\u5f02\u5e38 >> apiEnum = {},  exception = {}, request = {}", new Object[]{apiEnum, ExceptionUtils.getStackTrace((Throwable)e), request});
            throw FBankException.SERVER_EXCEPTION;
        }
    }

    static {
        FBankRequestClient.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

