/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.fbank.openapi.sdk.util;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtils {
    private static final String ALGORITHM_AES = "AES";
    private static final String SECURE_ALGORITHM_SHA1PRNG = "SHA1PRNG";
    private static final String ENCRYPT_ALGORITHM_ECB = "AES/ECB/PKCS5Padding";
    private static final String SECURE_ALGORITHM_PBKDF2 = "PBKDF2WithHmacSHA1";
    private static final String ENCRYPT_ALGORITHM_CBC = "AES/CBC/PKCS5Padding";
    private static final int KEY_LENGTH_128 = 128;
    private static final int KEY_LENGTH_16 = 16;
    private static volatile BouncyCastleProvider bouncyCastleProvider = new BouncyCastleProvider();

    public static String randomKey() {
        long randomKey = ThreadLocalRandom.current().nextLong();
        return String.valueOf(randomKey);
    }

    public static String encryptWithECB(String data, String key) throws Exception {
        byte[] aesData = AESUtils.doCipher(data.getBytes(StandardCharsets.UTF_8), key, 1);
        return Base64.encodeBase64String((byte[])aesData);
    }

    public static String decryptWithECB(String data, String key) throws Exception {
        byte[] plain = AESUtils.doCipher(Base64.decodeBase64((String)data), key, 2);
        return new String(plain, StandardCharsets.UTF_8);
    }

    private static byte[] doCipher(byte[] dataBytes, String key, int mode) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance(SECURE_ALGORITHM_SHA1PRNG);
        secureRandom.setSeed(key.getBytes(StandardCharsets.UTF_8));
        KeyGenerator keyGenerator = KeyGenerator.getInstance(ALGORITHM_AES);
        keyGenerator.init(128, secureRandom);
        SecretKey secretKey = keyGenerator.generateKey();
        SecretKeySpec keySpec = new SecretKeySpec(secretKey.getEncoded(), ALGORITHM_AES);
        Security.addProvider((Provider)bouncyCastleProvider);
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGORITHM_ECB);
        cipher.init(mode, keySpec);
        return cipher.doFinal(dataBytes);
    }

    public static String encryptWithCBC(String data, String key) throws Exception {
        SecretKeySpec secretKeySpec = AESUtils.secretKeyInitWithPBKDF2(key);
        Security.addProvider((Provider)bouncyCastleProvider);
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGORITHM_CBC);
        cipher.init(1, (Key)secretKeySpec, new IvParameterSpec(AESUtils.getIV(key)));
        byte[] encryptedDataBytes = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])encryptedDataBytes);
    }

    public static String decryptWithCBC(String data, String key) throws Exception {
        byte[] dataBytes = Base64.decodeBase64((String)data);
        Security.addProvider((Provider)bouncyCastleProvider);
        Cipher aesCipher = Cipher.getInstance(ENCRYPT_ALGORITHM_CBC);
        SecretKeySpec keySpec = AESUtils.secretKeyInitWithPBKDF2(key);
        aesCipher.init(2, (Key)keySpec, new IvParameterSpec(AESUtils.getIV(key)));
        byte[] decryptedDataBytes = aesCipher.doFinal(dataBytes);
        return new String(decryptedDataBytes, StandardCharsets.UTF_8);
    }

    private static SecretKeySpec secretKeyInitWithPBKDF2(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        int iterations = 1000;
        char[] chars = key.toCharArray();
        byte[] salt = String.valueOf(key.hashCode()).getBytes(StandardCharsets.UTF_8);
        PBEKeySpec spec = new PBEKeySpec(chars, salt, iterations, 128);
        SecretKeyFactory skf = SecretKeyFactory.getInstance(SECURE_ALGORITHM_PBKDF2);
        return new SecretKeySpec(skf.generateSecret(spec).getEncoded(), ALGORITHM_AES);
    }

    private static byte[] getIV(String key) {
        int keyLength = key.length();
        StringBuilder keyBuilder = new StringBuilder(key);
        while (keyLength < 16) {
            keyBuilder.append("0");
            keyLength = keyBuilder.length();
        }
        key = keyBuilder.toString();
        return Arrays.copyOf(key.getBytes(), 16);
    }

    public static void main(String[] args) throws Exception {
        String data = "testInfo";
        String aesKey = "1234567891234567";
        System.out.println(AESUtils.encryptWithECB(data, aesKey));
    }
}

