/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.fbank.openapi.sdk.service;

import cn.hutool.core.io.FileUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.com.fbank.openapi.sdk.client.OpenParameters;
import com.fshows.com.fbank.openapi.sdk.config.Configuration;
import com.fshows.com.fbank.openapi.sdk.config.FileConfiguration;
import com.fshows.com.fbank.openapi.sdk.constant.FileDownloadStatusEnum;
import com.fshows.com.fbank.openapi.sdk.crypto.CryptoSignatureService;
import com.fshows.com.fbank.openapi.sdk.service.AbstractOpenApiService;
import com.fshows.com.fbank.openapi.sdk.util.CryptoServiceUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.codec.digest.DigestUtils;

public class OpenApiFileDownloadService
extends AbstractOpenApiService {
    @Override
    protected String getRemoteAddress(Configuration configuration) {
        String path;
        String remoteFileAddress = configuration.remoteAddress();
        if (configuration instanceof FileConfiguration) {
            remoteFileAddress = ((FileConfiguration)configuration).remoteFileAddress();
        }
        if (!remoteFileAddress.endsWith("/")) {
            remoteFileAddress = remoteFileAddress + "/";
        }
        if ((path = this.getFilePath()).startsWith("/")) {
            path = path.substring(1);
        }
        return remoteFileAddress + path;
    }

    protected String getFilePath() {
        return "api/download";
    }

    @Override
    protected void setAlgorithm(Configuration configuration, HttpURLConnection connection, String moduleCode) {
        connection.setRequestProperty("algorithm", "fileDownload");
    }

    @Override
    public String verifyAndDecrypt(HttpURLConnection connection, Configuration configuration, OpenParameters context, byte[] response) throws Exception {
        String bizContent = this.getBizContent(connection);
        this.verifyFile(configuration, bizContent, response);
        this.downloadFile(configuration, context, response, bizContent);
        return "file download success";
    }

    private String getBizContent(HttpURLConnection connection) {
        String bizContentDecode;
        String bizContent = connection.getHeaderField("biz_content");
        try {
            bizContentDecode = URLDecoder.decode(bizContent, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            bizContentDecode = bizContent;
        }
        this.logger.info("bizContent is {}", (Object)bizContentDecode);
        return bizContentDecode;
    }

    protected static void checkFileStatus(JSONObject signDataJO) {
        String status = signDataJO.getString("status");
        if (FileDownloadStatusEnum.SUCCESS.getStatus().equalsIgnoreCase(status)) {
            return;
        }
        for (FileDownloadStatusEnum fileDownloadStatus : FileDownloadStatusEnum.values()) {
            if (!fileDownloadStatus.getStatus().equalsIgnoreCase(status)) continue;
            throw new RuntimeException(fileDownloadStatus.getMessage());
        }
        throw new RuntimeException(FileDownloadStatusEnum.OTHER.getMessage());
    }

    private void checkResponseCode(JSONObject bizContentJO) {
        String code = bizContentJO.getString("code");
        if (!"000000".equalsIgnoreCase(code)) {
            throw new RuntimeException(bizContentJO.getString("message"));
        }
    }

    private void verifyFile(Configuration configuration, String bizContent, byte[] response) throws Exception {
        JSONObject bizContentJO = JSONObject.parseObject((String)bizContent);
        this.checkResponseCode(bizContentJO);
        JSONObject signDataJO = bizContentJO.getJSONObject("sign_data");
        this.verifySignature(configuration, bizContentJO, signDataJO);
        OpenApiFileDownloadService.checkFileStatus(signDataJO);
        this.checkFileMD5(signDataJO, response);
    }

    private void verifySignature(Configuration configuration, JSONObject bizContentJO, JSONObject signDataJO) throws Exception {
        TreeMap signDataTreeMap;
        JSONObject signDataSorted;
        String signature = bizContentJO.getString("signature");
        CryptoSignatureService cryptoSignatureService = CryptoServiceUtils.getCryptoSignatureService(configuration.signType());
        boolean verifyResult = cryptoSignatureService.verifySignature((signDataSorted = new JSONObject(signDataTreeMap = new TreeMap(signDataJO))).toJSONString(), signature, configuration.fbankSignPubKey());
        if (!verifyResult) {
            throw new RuntimeException("verifyFile failed!");
        }
    }

    private void checkFileMD5(JSONObject signDataJO, byte[] response) {
        String responseMd5 = DigestUtils.md5Hex((byte[])response);
        String signDataMd5 = signDataJO.getString("md5");
        this.logger.info("request md5 is {}, get md5 from file is {}", (Object)signDataMd5, (Object)responseMd5);
        if (!responseMd5.equalsIgnoreCase(signDataMd5)) {
            throw new RuntimeException("md5 check failed");
        }
    }

    private void downloadFile(Configuration configuration, OpenParameters context, byte[] response, String bizContent) {
        Path path = Paths.get(this.getFileName(configuration, context, bizContent), new String[0]);
        try {
            if (!Files.notExists(path, new LinkOption[0])) {
                throw new RuntimeException("file already exists");
            }
            Files.createFile(path, new FileAttribute[0]);
            Files.write(path, response, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("file download failed");
        }
    }

    private String getFileName(Configuration configuration, OpenParameters context, String bizContent) {
        String fileName;
        JSONObject bizContentJO = JSONObject.parseObject((String)bizContent);
        JSONObject signData = bizContentJO.getJSONObject("sign_data");
        String fileType = signData.getString("file_type");
        FileConfiguration fileConfiguration = (FileConfiguration)configuration;
        String storagePath = fileConfiguration.storagePath();
        if (!storagePath.endsWith("/")) {
            storagePath = storagePath + "/";
        }
        if (!FileUtil.exist((String)storagePath)) {
            FileUtil.mkdir((String)storagePath);
        }
        if ((fileName = context.getFileName()) == null) {
            fileName = String.valueOf(ThreadLocalRandom.current().nextInt());
        }
        if (!fileName.contains(".")) {
            fileName = fileName + "." + fileType;
        }
        return storagePath + fileName;
    }
}

