/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version UnQrAppInfo.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class UnQrAppInfo implements Serializable {

    private static final long serialVersionUID = -6136176023123484535L;
    /**
     * 预下单订单号
     */
    @JSONField(name = "prepay_id")
    private String prepayId;

    /**
     * 银联云闪付app账号
     */
    @JSONField(name = "unqrapp_acc_no")
    private String unqrappAccNo;

    /**
     * 银联云闪付app接入类型
     */
    @JSONField(name = "unqrapp_access_type")
    private String unqrappAccessType;

    /**
     * 收单机构代码
     */
    @JSONField(name = "unqrapp_acq_ins_code")
    private String unqrappAcqInsCode;

    /**
     * 银联云闪付app产品类型
     */
    @JSONField(name = "unqrapp_biz_type")
    private String unqrappBizType;

    /**
     * 银联云闪付app有卡交易信息域
     */
    @JSONField(name = "unqrapp_card_trans_data")
    private String unqrappCardTransData;

    /**
     * 银联云闪付app清算汇率
     */
    @JSONField(name = "unqrapp_exchange_rate")
    private String unqrappExchangeRate;

    /**
     * 银联云闪付app商户号
     */
    @JSONField(name = "unqrapp_mer_id")
    private String unqrappMerId;

    /**
     * 银联云闪付app原交易查询流水号，撤销与退货中使用
     */
    @JSONField(name = "unqrapp_orig_qry_id")
    private String unqrappOrigQryId;

    /**
     * 银联云闪付app支付卡类型
     */
    @JSONField(name = "unqrapp_pay_card_type")
    private String unqrappPayCardType;

    /**
     * 银联云闪付app请求方保留数据
     */
    @JSONField(name = "unqrapp_req_reserved")
    private String unqrappReqReserved;

    /**
     * 银联云闪付app请求信息
     */
    private UnQrAppReserved unqrappreserved;

    /**
     * 银联云闪付app系统跟踪号
     */
    @JSONField(name = "unqrapp_trace_no")
    private String unqrappTraceNo;

    /**
     * 银联云闪付app交易子类
     */
    @JSONField(name = "unqrapp_txn_sub_type")
    private String unqrappTxnSubType;

    /**
     * 银联云闪付app请求时间
     */
    @JSONField(name = "unqrapp_txn_time")
    private String unqrappTxnTime;

    /**
     * 银联云闪付app交易类型
     */
    @JSONField(name = "unqrapp_txn_type")
    private String unqrappTxnType;

    /**
     * 银联云闪付app版本号
     */
    @JSONField(name = "unqrapp_version")
    private String unqrappVersion;
}