/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.WechatConfigQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version WechatConfigQueryRequest.java, v 0.1 2023-11-04 15:16 zhubo
 */
@Data
public class WechatConfigQueryRequest extends EasyPayMerchantBaseRequest<WechatConfigQueryResponse> {
    private static final long serialVersionUID = 9034744545315404043L;

    /**
     * 微信号
     */
    @NotBlank
    private String wechatId;

    /**
     * 报文类型
     */
    private String messageType = "QUERYWXCONFIG";

    @Override
    public Class<WechatConfigQueryResponse> getResponseClass() {
        return null;
    }
}
