/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantAuditQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version MerchatnAuditQueryRequest.java, v 0.1 2023-11-04 14:42 zhubo
 */
@Data
public class MerchantAuditQueryRequest extends EasyPayMerchantBaseRequest<MerchantAuditQueryResponse> {
    private static final long serialVersionUID = 7135489647895917056L;

    /**
     * 商户唯一标识
     */
    private String merTrace;

    /**
     * 原操作流水号，最长20字符
     */
    @NotBlank
    @Length(max = 20, message = "operaTrace操作流水号长度不能超过20")
    private String operaTrace;

    /**
     * 消息类型
     */
    private String messageType = "QUERYAUDMER";

    @Override
    public Class<MerchantAuditQueryResponse> getResponseClass() {
        return MerchantAuditQueryResponse.class;
    }
}
