/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantIncomeResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author zhubo
 * @version MerchantIncomeRequest.java, v 0.1 2023-11-04 11:09 zhubo
 */
@Data
public class MerchantIncomeRequest extends EasyPayMerchantBaseRequest<MerchantIncomeResponse> {
    private static final long serialVersionUID = -329204022746823218L;

    /**
     * 回调url
     */
    private String backUrl;

    /**
     * 商家信息
     */
    @NotBlank
    private String merInfo;

    /**
     * 附加信息
     */
    @NotBlank
    private String plusInfo;

    /**
     * 终端信息
     */
    private String sysInfo;

    /**
     * 营业执照信息
     */
    @NotBlank
    private String licInfo;

    /**
     * 结算账户信息
     */
    @NotBlank
    private String accInfo;

    /**
     * 结算账户信息2
     * 当商户类型（merMode）为企业商户并且结算账户为对私账户时，该字段必传；json 格式字符串
     */
    private String accInfoBak;

    /**
     * 功能信息
     */
    @NotNull
    private List<String> funcInfo;

    /**
     * 产品信息
     * json 格式字符串 (list) 特殊场景下使用
     */
    private List<String> prodList;

    /**
     * 图片信息
     */
    @NotNull
    private List<String> picInfoList;

    /**
     * 该字段为机构上送的操作流水号，机构唯一；用于查询操作结果；
     */
    @NotBlank
    @Length(max = 20, message = "operaTrace操作流水号长度不能超过20")
    private String operaTrace;

    /**
     * 默认0； 0 否 1 使用，是否使用易生签约流程，当使用易生签约流程时，需要调用签约接口否则无法审核， 备注：字符串类型
     * 固定传为1使用
     */
    private String isContract;

    /**
     * json 格式字符串，需和易生约定特殊使用
     */
    private String customInfo;

    private String messageType = "AGMERAPPLY";

    @Override
    public Class<MerchantIncomeResponse> getResponseClass() {
        return MerchantIncomeResponse.class;
    }
}
