/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.order;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import com.fshows.easypay.sdk.response.trade.scanpay.ScanPayAppendRespDataResponse;
import lombok.Data;

/**
 * @author zhangmj
 * @version EasyPayOrderQueryResponse.java, v 0.1 2023-10-31 09:37 zhangmj
 */
@Data
public class EasyPayOrderQsQueryResponse extends EasyPayDataBaseResponse {

    private static final long serialVersionUID = 4694043503986408243L;

    private ScanPayAppendRespDataResponse appendData;

    /**
     * 订单状态 0 待处理 1 代付成功 2 代付失败 3 代付已发送 4 手续费查询失败
     */
    @JSONField(name = "order_status")
    private String orderStatus;

    /**
     * 终端商户号
     */
    @JSONField(name = "term_mercode")
    private String termMercode;

    /**
     * 终端号
     */
    @JSONField(name = "term_no")
    private String termNo;

    /**
     * 易生订单号(全局唯一)
     */
    @JSONField(name = "order_no")
    private String orderNo;


    /**
     * 原交易业务日期
     */
    @JSONField(name = "trade_time")
    private String tradeTime;

    /**
     * 原交易业务日期
     */
    @JSONField(name = "settle_date")
    private String settleDate;

    /**
     * 商户订单号
     */
    @JSONField(name = "mer_order_no")
    private String merOrderNo;

    /**
     * 原交易金额
     */
    @JSONField(name = "trade_amt")
    private String tradeAmt;

    /**
     * 原结算金额
     */
    @JSONField(name = "settle_amt")
    private String settleAmt;

    /**
     * 渠道消息
     */
    @JSONField(name = "channel_msg")
    private String channelMsg;

    /**
     * 渠道错误码
     */
    @JSONField(name = "channel_code")
    private String channelCode;


    /**
     * 代付金额
     */
    @JSONField(name = "df_amt")
    private String dfAmt;

    /**
     * 代付手续费
     */
    @JSONField(name = "df_fee")
    private String dfFee;

    /**
     * 渠道商户号
     */
    @JSONField(name = "channel_mer_code")
    private String channelMerCode;

    /**
     * 渠道终端号
     */
    @JSONField(name = "channel_ter_code")
    private String channelTermNo;

    /**
     * 渠道订单号
     */
    @JSONField(name = "channel_order_no")
    private String channelOrderNo;

    /**
     * 渠道成功时间
     */
    @JSONField(name = "channel_time")
    private String channelTime;

    /**
     * 对账用流水号
     */
    @JSONField(name = "record_id")
    private String recordId;

    /**
     * 业务响应码
     */
    private String sysRetcode;

    /**
     * 业务响应说明
     */
    private String sysRetmsg;
}