/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.hardware;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.hardware.MachineNumberStorageResponse;
import lombok.Data;

/**
 * @author liubo
 * @version MachineNumberStorageRequest.java, v 0.1 2023-11-13 11:09 liubo
 */
@Data
public class MachineNumberStorageRequest extends EasyPayMerchantBaseRequest<MachineNumberStorageResponse> {
    private static final long serialVersionUID = -7267515514694597679L;

    /**
     * 机具号列表信息
     */
    private String termModelLicList;

    private String messageType = "ADDTERMLIC";

    @Override
    public Class<MachineNumberStorageResponse> getResponseClass() {
        return MachineNumberStorageResponse.class;
    }
}
