/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.client.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.fshows.easypay.sdk.client.EasyPayBaseClient;
import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.enums.EasyPayApiEnum;
import com.fshows.easypay.sdk.enums.SignTypeEnum;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.base.EasyPayDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.EasyPayQsTradeDataBaseRequest;
import com.fshows.easypay.sdk.request.trade.EasyPayTradeDataBaseRequest;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import com.fshows.easypay.sdk.util.EasyPayRequestUtils;
import com.fshows.easypay.sdk.util.FsHttpUtil;
import com.fshows.easypay.sdk.util.LogUtil;
import com.fshows.easypay.sdk.util.ReqSerialNoUtil;
import com.fshows.easypay.sdk.util.SignUtil;
import com.fshows.easypay.sdk.util.ValidateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPayBaseClientImpl
implements EasyPayBaseClient {
    private static final Logger log = LoggerFactory.getLogger(EasyPayBaseClientImpl.class);
    @NotBlank
    protected String apiParentUrl;
    @NotBlank
    private final String orgId;
    @NotBlank
    private final String signType;
    @NotBlank
    private String fubeiPrivateKey;
    @NotBlank
    private String easyPayPublicKey;
    private Boolean signFilterNull = false;
    protected int connectionTimeout = 5000;
    protected int readTimeout = 20000;

    public EasyPayBaseClientImpl(String apiParentUrl, String orgId, String signType, String fubeiPrivateKey, String easyPayPublicKey) {
        this.apiParentUrl = apiParentUrl;
        this.orgId = orgId;
        this.signType = signType;
        this.fubeiPrivateKey = fubeiPrivateKey;
        this.easyPayPublicKey = easyPayPublicKey;
    }

    public EasyPayBaseClientImpl(String apiParentUrl, String orgId, String signType, String fubeiPrivateKey, String easyPayPublicKey, int connectionTimeout, int readTimeout) {
        this.apiParentUrl = apiParentUrl;
        this.orgId = orgId;
        this.signType = signType;
        this.fubeiPrivateKey = fubeiPrivateKey;
        this.easyPayPublicKey = easyPayPublicKey;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
    }

    @Override
    public <T extends EasyPayDataBaseResponse, R extends EasyPayApiDefinition> T execute(EasyPayDataBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws EasyPayException {
        return this.execute(request, tradeApiDefinitionEnum, null);
    }

    @Override
    public <T extends EasyPayDataBaseResponse, R extends EasyPayApiDefinition> T execute(EasyPayDataBaseRequest<T, R> request, R tradeApiDefinitionEnum, String subAppId) throws EasyPayException {
        String method = tradeApiDefinitionEnum.getMethod();
        this.validateParam(request, method);
        long startTime = System.currentTimeMillis();
        String url = this.apiParentUrl + method;
        try {
            String requestData = this.getRequestData(request, subAppId);
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={},request={}", (Object)url, (Object)requestData);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            headers.put("Accept-Encoding", "identity");
            String fsHttpResult = FsHttpUtil.postString(url, requestData, "utf-8", "application/json;charset=utf-8", this.connectionTimeout, this.readTimeout, headers);
            log.info("record bad-liquidation info >> success >> \u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={}, request={},cost={}", new Object[]{url, request, System.currentTimeMillis() - startTime});
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={},request={},response={},cost={}", new Object[]{url, requestData, fsHttpResult, System.currentTimeMillis() - startTime});
            if (fsHttpResult != null) {
                return (T)this.parseResponse(fsHttpResult, tradeApiDefinitionEnum);
            }
        }
        catch (Exception ex) {
            log.error("record bad-liquidation info >> fail >>\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={}, request={},ex={},cost={}", new Object[]{url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            log.error("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={},request={},ex={},cost={}", new Object[]{url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new EasyPayException(ex.getMessage());
        }
        return null;
    }

    private <R extends EasyPayApiDefinition> EasyPayDataBaseResponse parseResponse(String fsHttpResult, R tradeApiDefinitionEnum) throws Exception {
        if (!this.checkSign(fsHttpResult)) {
            LogUtil.error(log, "\u3010easypay-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> fsHttpResult={}", fsHttpResult);
            throw new EasyPayException("[easypay-sdk]\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
        }
        JSONObject resMap = JSONObject.parseObject((String)fsHttpResult);
        JSONObject responseJson = new JSONObject();
        JSONObject data = resMap.getJSONObject("data");
        JSONObject appendData = resMap.getJSONObject("appendData");
        if (CollUtil.isNotEmpty((Map)data)) {
            responseJson.putAll((Map)data);
        }
        if (CollUtil.isNotEmpty((Map)appendData)) {
            responseJson.put("appendData", (Object)appendData);
        }
        try {
            EasyPayDataBaseResponse response = (EasyPayDataBaseResponse)EasyPayRequestUtils.getObjectFromMap((Map<String, Object>)responseJson, tradeApiDefinitionEnum.getResponseClass());
            String sysRetcode = StrUtil.blankToDefault((CharSequence)resMap.getString("sysRetcode"), (String)resMap.getString("sysRetCode"));
            String sysRetmsg = StrUtil.blankToDefault((CharSequence)resMap.getString("sysRetmsg"), (String)resMap.getString("sysRetMsg"));
            if (StrUtil.isBlank((CharSequence)sysRetcode) && StrUtil.isBlank((CharSequence)sysRetmsg)) {
                sysRetcode = StrUtil.blankToDefault((CharSequence)resMap.getString("resultCode"), (String)resMap.getString("resultCode"));
                sysRetmsg = StrUtil.blankToDefault((CharSequence)resMap.getString("resultMsg"), (String)resMap.getString("resultMsg"));
            }
            response.setSysRetcode(sysRetcode);
            response.setSysRetmsg(sysRetmsg);
            response.setAppendRetcode(response.getAppendRetcode());
            response.setAppendRetmsg(response.getAppendRetmsg());
            response.setResMap((Map<String, Object>)resMap);
            return response;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010easypay-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> fsHttpResult={}", e, fsHttpResult);
            throw new EasyPayException("[easypay-sdk]\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38");
        }
    }

    private boolean checkSign(String fsHttpResult) {
        JSONObject resMap = JSONObject.parseObject((String)fsHttpResult);
        if ("000000".equals(resMap.getString("sysRetcode")) || "000000".equals(resMap.getString("sysRetCode"))) {
            String sign = resMap.getString("sign");
            if (StringUtils.isEmpty((CharSequence)sign)) {
                return false;
            }
            Object bizResult = resMap.getJSONObject("data");
            if (Boolean.TRUE.equals(this.signFilterNull) && bizResult != null) {
                bizResult = bizResult.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            return CollUtil.isNotEmpty((Map)bizResult) && SignUtil.verifySign((Map<String, Object>)bizResult, this.signType, resMap.get((Object)"sign").toString(), this.easyPayPublicKey);
        }
        return true;
    }

    private String getRequestData(EasyPayDataBaseRequest request, String appId) throws Exception {
        EasyPayDataBaseRequest tradeDataBaseRequest;
        HashMap<String, Object> requestDataMap = new HashMap<String, Object>();
        requestDataMap.put("orgId", StringUtils.defaultIfBlank((CharSequence)appId, (CharSequence)this.orgId));
        if (request instanceof EasyPayTradeDataBaseRequest) {
            tradeDataBaseRequest = (EasyPayTradeDataBaseRequest)request;
            requestDataMap.put("orgMercode", ((EasyPayTradeDataBaseRequest)tradeDataBaseRequest).getOrgMercode());
            requestDataMap.put("orgTermno", ((EasyPayTradeDataBaseRequest)tradeDataBaseRequest).getOrgTermno());
            requestDataMap.put("orgTrace", StrUtil.blankToDefault((CharSequence)((EasyPayTradeDataBaseRequest)tradeDataBaseRequest).getOrgTrace(), (String)ReqSerialNoUtil.getReqSerialNo()));
        }
        if (request instanceof EasyPayQsTradeDataBaseRequest) {
            tradeDataBaseRequest = (EasyPayQsTradeDataBaseRequest)request;
            requestDataMap.put("orgMercode", ((EasyPayQsTradeDataBaseRequest)tradeDataBaseRequest).getOrgMercode());
            requestDataMap.put("orgTermno", ((EasyPayQsTradeDataBaseRequest)tradeDataBaseRequest).getOrgTermno());
        }
        TreeMap<String, String> bizParamMap = SignUtil.getSignParameterMap(request);
        String sign = SignUtil.generateSign(bizParamMap, SignTypeEnum.getByValue(this.signType).getAlgorithm(), this.fubeiPrivateKey);
        requestDataMap.put("sign", sign);
        requestDataMap.put("signType", this.signType);
        requestDataMap.put("appendData", request.getAppendData());
        requestDataMap.put("data", bizParamMap);
        return JSONObject.toJSONString(requestDataMap);
    }

    private <R> void validateParam(EasyPayDataBaseRequest request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.fubeiPrivateKey)) {
            throw new IllegalArgumentException("\u79c1\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.easyPayPublicKey)) {
            throw new IllegalArgumentException("\u516c\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.signType)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == SignTypeEnum.getByValue(this.signType)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == EasyPayApiEnum.getByValue(method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    public void setSignFilterNull(Boolean signFilterNull) {
        this.signFilterNull = signFilterNull;
    }

    private EasyPayBaseClientImpl() {
        this.orgId = null;
        this.signType = null;
    }

    public String getApiParentUrl() {
        return this.apiParentUrl;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public String getSignType() {
        return this.signType;
    }

    public String getFubeiPrivateKey() {
        return this.fubeiPrivateKey;
    }

    public String getEasyPayPublicKey() {
        return this.easyPayPublicKey;
    }

    public Boolean getSignFilterNull() {
        return this.signFilterNull;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setApiParentUrl(String apiParentUrl) {
        this.apiParentUrl = apiParentUrl;
    }

    public void setFubeiPrivateKey(String fubeiPrivateKey) {
        this.fubeiPrivateKey = fubeiPrivateKey;
    }

    public void setEasyPayPublicKey(String easyPayPublicKey) {
        this.easyPayPublicKey = easyPayPublicKey;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EasyPayBaseClientImpl)) {
            return false;
        }
        EasyPayBaseClientImpl other = (EasyPayBaseClientImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiParentUrl = this.getApiParentUrl();
        String other$apiParentUrl = other.getApiParentUrl();
        if (this$apiParentUrl == null ? other$apiParentUrl != null : !this$apiParentUrl.equals(other$apiParentUrl)) {
            return false;
        }
        String this$orgId = this.getOrgId();
        String other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !this$orgId.equals(other$orgId)) {
            return false;
        }
        String this$signType = this.getSignType();
        String other$signType = other.getSignType();
        if (this$signType == null ? other$signType != null : !this$signType.equals(other$signType)) {
            return false;
        }
        String this$fubeiPrivateKey = this.getFubeiPrivateKey();
        String other$fubeiPrivateKey = other.getFubeiPrivateKey();
        if (this$fubeiPrivateKey == null ? other$fubeiPrivateKey != null : !this$fubeiPrivateKey.equals(other$fubeiPrivateKey)) {
            return false;
        }
        String this$easyPayPublicKey = this.getEasyPayPublicKey();
        String other$easyPayPublicKey = other.getEasyPayPublicKey();
        if (this$easyPayPublicKey == null ? other$easyPayPublicKey != null : !this$easyPayPublicKey.equals(other$easyPayPublicKey)) {
            return false;
        }
        Boolean this$signFilterNull = this.getSignFilterNull();
        Boolean other$signFilterNull = other.getSignFilterNull();
        if (this$signFilterNull == null ? other$signFilterNull != null : !((Object)this$signFilterNull).equals(other$signFilterNull)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        return this.getReadTimeout() == other.getReadTimeout();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EasyPayBaseClientImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiParentUrl = this.getApiParentUrl();
        result = result * 59 + ($apiParentUrl == null ? 43 : $apiParentUrl.hashCode());
        String $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : $orgId.hashCode());
        String $signType = this.getSignType();
        result = result * 59 + ($signType == null ? 43 : $signType.hashCode());
        String $fubeiPrivateKey = this.getFubeiPrivateKey();
        result = result * 59 + ($fubeiPrivateKey == null ? 43 : $fubeiPrivateKey.hashCode());
        String $easyPayPublicKey = this.getEasyPayPublicKey();
        result = result * 59 + ($easyPayPublicKey == null ? 43 : $easyPayPublicKey.hashCode());
        Boolean $signFilterNull = this.getSignFilterNull();
        result = result * 59 + ($signFilterNull == null ? 43 : ((Object)$signFilterNull).hashCode());
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getReadTimeout();
        return result;
    }

    public String toString() {
        return "EasyPayBaseClientImpl(apiParentUrl=" + this.getApiParentUrl() + ", orgId=" + this.getOrgId() + ", signType=" + this.getSignType() + ", fubeiPrivateKey=" + this.getFubeiPrivateKey() + ", easyPayPublicKey=" + this.getEasyPayPublicKey() + ", signFilterNull=" + this.getSignFilterNull() + ", connectionTimeout=" + this.getConnectionTimeout() + ", readTimeout=" + this.getReadTimeout() + ")";
    }
}

