/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.trade.scanpay;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version ScanPayDataResponse.java, v 0.1 2023-10-30 11:57 zhaoxumin
 */
@Data
public class ScanPayDataResponse extends EasyPayDataBaseResponse implements Serializable {

    private static final long serialVersionUID = 4431026950713805084L;

    private ScanPayAppendRespDataResponse appendData;

    /**
     * 附加状态码，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retcode")
    private String appendRetcode;

    /**
     * 附加状态描述，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retmsg")
    private String appendRetmsg;

    /**
     * 交易状态码
     */
    @JSONField(name = "fin_retcode")
    private String finRetcode;

    /**
     * 交易码-查看文档
     */
    @JSONField(name = "trade_code")
    private String tradeCode;

    /**
     * 交易金额
     */
    @JSONField(name = "trade_amt")
    private Long tradeAmt;

    /**
     * 请求渠道-订单号；长度：50
     */
    @JSONField(name = "out_trace")
    private String outTrace;

    /**
     * 正常情况下按请求报文，原文返回；请求报文里上送希望D0清算，但商户功能未开通功能，或功能受限时返回值为：X
     */
    @JSONField(name = "patner_settle_flag")
    private String patnerSettleFlag;

    /**
     * 实际付款金额
     */
    @JSONField(name = "payer_amt")
    private Long payerAmt;

    /**
     * 用户唯一标识。W：支付的appId下的openId；Z：支付宝用户唯一标识buyer_user_id；
     */
    @JSONField(name = "payer_id")
    private String payerId;

    /**
     * 按类型取值为：W:机构appId下的openId；Z:支付宝登录账号（脱敏）；
     */
    @JSONField(name = "payer_other_info")
    private String payerOtherInfo;

    /**
     * 渠道返回-订单号；长度：50
     */
    @JSONField(name = "pc_trace")
    private String pcTrace;

    /**
     * 清算金额
     */
    @JSONField(name = "settle_amt")
    private Long settleAmt;

    /**
     * 支付完成/清算日期 yyyyMMdd
     */
    @JSONField(name = "settle_date")
    private String settleDate;

    /**
     * 支付完成时间 yyyyMMddHHmmss
     */
    @JSONField(name = "time_end")
    private String timeEnd;

    /**
     * 用户唯一编码
     */
    @JSONField(name = "user_id")
    private String userId;
}