/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.order;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.easypay.sdk.response.base.EasyPayDataBaseResponse;
import com.fshows.easypay.sdk.response.trade.scanpay.ScanPayAppendRespDataResponse;
import lombok.Data;

/**
 * @author zhangmj
 * @version EasyPayOrderQueryResponse.java, v 0.1 2023-10-31 09:37 zhangmj
 */
@Data
public class EasyPayOrderQueryResponse extends EasyPayDataBaseResponse {

    private static final long serialVersionUID = 4694043503986408243L;

    private ScanPayAppendRespDataResponse appendData;

    /**
     * 附加状态码，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retcode")
    private String appendRetcode;

    /**
     * 附加状态描述，一般为支付渠道原文返回
     */
    @JSONField(name = "append_retmsg")
    private String appendRetmsg;

    /**
     * 交易状态码
     */
    @JSONField(name = "fin_retcode")
    private String finRetcode;

    /**
     * 交易流水，28位定长，规则：orgId 前四位+后四位+yyyyMMddhhmmss+6位自定义 合计28位长度（唯一）
     */
    @JSONField(name = "ori_org_trace")
    private String oriOrgTrace;

    /**
     * 用户开放标识，用户ID
     */
    @JSONField(name = "payer_id")
    private String payerId;

    /**
     * 二维码链接
     */
    @JSONField(name = "qr_code")
    private String qrCode;

    /**
     * 交易码—&showDoc
     */
    @JSONField(name = "trade_code")
    private String tradeCode;

    /**
     * 交易金额，单位分；取值范围：1-10000000000
     */
    @JSONField(name = "trade_amt")
    private Long tradeAmt;

    /**
     * 请求渠道-订单号；长度：50
     */
    @JSONField(name = "out_trace")
    private String outTrace;

    /**
     * 卡类型：借记卡D 贷记卡C
     */
    @JSONField(name = "out_cdno_type")
    private String outCdnoType;

    /**
     * 正常情况下按请求报文，原文返回；请求报文里上送希望D0清算，但商户功能未开通功能，或功能受限时返回值为：X
     */
    @JSONField(name = "patner_settle_flag")
    private String patnerSettleFlag;

    /**
     * 实际付款金额
     */
    @JSONField(name = "payer_amt")
    private Long payerAmt;

    /**
     * 按类型取值为：W:机构appId下的openId；Z:支付宝登录账号（脱敏）
     */
    @JSONField(name = "payer_other_info")
    private String payerOtherInfo;

    /**
     * 渠道返回-订单号；长度：50
     */
    @JSONField(name = "pc_trace")
    private String pcTrace;

    /**
     * 清算金额
     */
    @JSONField(name = "settle_amt")
    private Long settleAmt;

    /**
     * 支付完成/清算 日期 yyyyMMdd
     */
    @JSONField(name = "settle_date")
    private String settleDate;

    /**
     * 支付完成 时间 yyyyMMddHHmmss
     */
    @JSONField(name = "time_end")
    private String timeEnd;

    /**
     * 风险控制信息
     */
    @JSONField(name = "risk_info")
    private String riskInfo;

    /**
     * 用户唯一编码
     */
    @JSONField(name = "user_id")
    private String userId;
}