/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.hardware;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.hardware.AuthCodeQueryResponse;
import lombok.Data;


/**
 * @author zhubo
 * @version MerchatnAuditQueryRequest.java, v 0.1 2023-11-04 14:42 zhubo
 */
@Data
public class AuthCodeQueryRequest extends EasyPayMerchantBaseRequest<AuthCodeQueryResponse> {
    private static final long serialVersionUID = 7135489647895917056L;

    /**
     * 商户唯一标识
     */
    private String merTrace;

    /**
     * 商户号
     */
    private String termMercode;

    /**
     * 终端号
     */
    private String termTermcode;

    /**
     * 消息类型
     */
    private String messageType = "QUERYAUTH";

    @Override
    public Class<AuthCodeQueryResponse> getResponseClass() {
        return AuthCodeQueryResponse.class;
    }
}
