/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.easypay.sdk.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 业务公共请求参数的基础父类
 *
 * @author zhaoxumin
 * @version EasyPayBizRequest.java, v 0.1 2023-10-27 13:38
 */
@Data
public class EasyPayBizARequest implements Serializable {

    private static final long serialVersionUID = -2796897972276559034L;
    /**
     * 机构号
     */
    @NotBlank
    @JSONField(name = "org_id")
    private String orgId;

    /**
     * 产品码(不超过5位)
     */
    @JSONField(name = "prod_code")
    private String prodCode;

    /**
     * 签名
     */
    @NotBlank
    private String sign;

    /**
     * 签名方式
     */
    @NotBlank
    @JSONField(name = "sign_type")
    private String signType;

    /**
     * 产品流水
     */
    @JSONField(name = "prod_trace")
    private String prodTrace;

    /**
     * 请求方自定义信息
     */
    @JSONField(name = "org_info")
    private String orgInfo;

    /**
     * 业务请求数据，签名数据
     */
    private EasyPayDataBaseRequest data;
}