/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhangmj
 * @version PlusInfo.java, v 0.1 2023-11-02 21:09 zhangmj
 */
@Data
public class PlusInfo implements Serializable {

    private static final long serialVersionUID = -8315784393159710964L;

    /**
     * 法定代表人姓名，长度为50，不可变更
     **/

    @Length(max = 50, message = "merLegal法定代表人姓名长度不超过50")
    private String merLegal;

    /**
     * 法人证件类型：0-居民身份证或临时身份证；1-外国公民护照；2-港澳居民来往大陆通行证或其他有效旅游证件；3-其他类个人身份有效证件；4-单位证件；5-军人或武警身份证件，长度为1，不可变更
     **/

    @Length(max = 1, message = "legalType法人证件类型长度不超过1")
    private String legalType;

    /**
     * 法人证件号码，长度为30，不可变更
     **/

    @Length(max = 30, message = "legalCode法人证件号码长度不超过30")
    private String legalCode;

    /**
     * 证件有效期 格式：[“起始日期”，”截止日期”],JSON格式字符串，例如：[“2011.01.01”，”2039.01.01”],长期传2039.01.01，长度为30，可变更
     **/
    private List<String> legalValidity;

    /**
     * 手机号，长度为30，可变更
     **/

    @Length(max = 30, message = "legalPhone手机号长度不超过30")
    private String legalPhone;

    /**
     * 固定电话，长度为30，可变更
     **/
    @Length(max = 30, message = "legalMobile固定电话长度不超过30")
    private String legalMobile;

    /**
     * 商户联系人姓名，长度为50，可变更
     **/

    @Length(max = 50, message = "linkMan商户联系人姓名长度不超过50")
    private String linkMan;

    /**
     * 证件类型：0-居民身份证或临时身份证；1-外国公民护照；2-港澳居民来往大陆通行证或其他有效旅游证件；3-其他类个人身份有效证件；4-单位证件；5-军人或武警身份证件，长度为1，可变更
     **/

    @Length(max = 1, message = "linkmanType证件类型长度不超过1")
    private String linkmanType;

    /**
     * 证件号码，长度为30，可变更
     **/

    @Length(max = 30, message = "linkmanCode证件号码长度不超过30")
    private String linkmanCode;

    /**
     * 证件有效期 格式：[“起始日期”，”截止日期”],JSON格式字符串 ，若为长期，都传2039.01.01，长度为30，可变更
     **/
    private List<String> linkmanValidity;

    /**
     * 手机号，长度为30，可变更
     **/

    @Length(max = 30, message = "linkmanPhone手机号长度不超过30")
    private String linkmanPhone;

    /**
     * 固定电话，长度为30，可变更
     **/
    @Length(max = 30, message = "linkmanMobile固定电话长度不超过30")
    private String linkmanMobile;

    /**
     * 商户网址，长度为50，可变更
     **/
    @Length(max = 50, message = "webSite商户网址长度不超过50")
    private String webSite;

    /**
     * 网站或APP名称，长度为50，可变更
     **/
    @Length(max = 50, message = "webName网站或APP名称长度不超过50")
    private String webName;

    /**
     * ICP许可证编号，长度为30，可变更
     **/
    @Length(max = 30, message = "webIcpICP许可证编号长度不超过30")
    private String webIcp;

    /**
     * 附加信息，长度为150，可变更
     **/
    @Length(max = 150, message = "additionMess附加信息长度不超过150")
    private String additionMess;

    /**
     * 合作银行支行，长度为150，可变更
     **/
    @Length(max = 150, message = "branchName合作银行支行长度不超过150")
    private String branchName;

    /**
     * 合作银行客户经理，长度为30，不可变更
     **/
    @Length(max = 30, message = "branchManager合作银行客户经理长度不超过30")
    private String branchManager;

    /**
     * 电子协议编号 电子协议与协议图片2选1必传，长度为30，可变更
     **/
    @Length(max = 30, message = "contractNo电子协议编号长度不超过30")
    private String contractNo;

    /**
     * 签署方名称 电子协议与协议图片2选1必传，长度为100，可变更
     **/
    @Length(max = 100, message = "signatoryName签署方名称长度不超过100")
    private String signatoryName;
}