/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhangmj
 * @version LicInfo.java, v 0.1 2023-11-02 21:20 zhangmj
 */
@Data
public class LicInfo implements Serializable {

    private static final long serialVersionUID = -8070648028124400952L;

    /**
     * 工商注册号/统一社会信用码（营业执照），merMode为0,1时，必传
     **/
    @Length(max = 50, message = "merLic统一社会信用码长度不能超过50")
    private String merLic;
    /**
     * 默认：01 ； 营业执照类型 01：统一社会信用码，02：其他证明文件，03：工商注册号 04：事业单位法人证书 05：民办非企业单位登记证书 06：基金会法人登记证书
     **/
    @Length(max = 2, message = "licenseType 营业执照类型 长度不能超过2")
    private String licenseType;
    /**
     * 营业执照有效期 格式：[“起始日期”，”截止日期”],JSON格式字符串 ,merMode为0,1时，必传
     **/
    @Length(max = 30, message = "licValidity营业执照有效期长度不能超过30")
    private String licValidity;
    /**
     * 注册名称
     **/
    @Length(max = 100, message = "licName注册名称长度不能超过100")
    private String licName;
    /**
     * 主营业务
     **/

    @Length(max = 500, message = "businScope主营业务长度不能超过500")
    private String businScope;
    /**
     * 注册资本：单位-万元
     **/

    @Length(max = 20, message = "capital注册资本长度不能超过20")
    private String capital;
    /**
     * 注册资本币种：默认-人民币
     **/
    @Length(max = 10, message = "capitalCurrency注册资本币种长度不能超过10")
    private String capitalCurrency;
    /**
     * 注册地址
     **/

    @Length(max = 200, message = "licAddr注册地址长度不能超过200")
    private String licAddr;
    /**
     * 控股股东或实际控制人姓名或名称
     **/

    @Length(max = 30, message = "controlerName控股股东或实际控制人姓名或名称长度不能超过30")
    private String controlerName;
    /**
     * 控股股东或实际控制人证件号码
     **/

    @Length(max = 20, message = "controlerLegalCode控股股东或实际控制人证件号码长度不能超过20")
    private String controlerLegalCode;
    /**
     * 控股股东或实际控制人证件种类：0-居民身份证或临时身份证；1-外国公民护照；2-港澳居民来往大陆通行证或其他有效旅游证件；3-其他类个人身份有效证件；4-单位证件；5-军人或武警身份证件
     **/

    @Length(max = 1, message = "controlerLegalType控股股东或实际控制人证件种类长度不能超过1")
    private String controlerLegalType;
    /**
     * 控股股东或实际控制人证件有效期
     **/
    private List<String> controlerLegalValidity;
    /**
     * 控股股东或实际控制人证出资金额：单位-万元
     **/
    @Length(max = 20, message = "controlerCapital控股股东或实际控制人证出资金额长度不能超过20")
    private String controlerCapital;
    /**
     * 控股股东或实际控制人出资日期
     **/
    @Length(max = 20, message = "controlerDate控股股东或实际控制人出资日期长度不能超过20")
    private String controlerDate;
    /**
     * 控股股东或实际控制人控股股权比例
     **/
    @Length(max = 10, message = "controlerRate控股股东或实际控制人控股股权比例长度不能超过10")
    private String controlerRate;
}