/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.WechatAppIdConfigResponse;
import lombok.Data;

/**
 * @author zhubo
 * @version WechatAppIdConfigRequest.java, v 0.1 2023-11-04 15:08 zhubo
 */
@Data
public class WechatAppIdConfigRequest extends EasyPayMerchantBaseRequest<WechatAppIdConfigResponse> {
    private static final long serialVersionUID = -241829293155053410L;

    /**
     * 微信号
     */
    private String wechatId;

    /**
     * 应用程序id
     */
    private String appId;

    @Override
    public Class<WechatAppIdConfigResponse> getResponseClass() {
        return WechatAppIdConfigResponse.class;
    }
}
