/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.base.EasyPayMerchantBaseRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantSettleUpdateResponse;
import com.fshows.easypay.sdk.response.merchant.info.AccInfo;
import com.fshows.easypay.sdk.response.merchant.info.AccInfoBak;
import com.fshows.easypay.sdk.response.merchant.info.CustomInfo;
import com.fshows.easypay.sdk.response.merchant.info.PictureInfo;
import lombok.Data;

import java.util.List;

/**
 * @author zhubo
 * @version MerchantSettleUpdateRequest.java, v 0.1 2023-11-04 14:51 zhubo
 */
@Data
public class MerchantSettleUpdateRequest extends EasyPayMerchantBaseRequest<MerchantSettleUpdateResponse> {
    private static final long serialVersionUID = 5946172668419574876L;

    /**
     * 回调url
     */
    private String backUrl;

    /**
     * 商户唯一标识
     */
    private String merTrace;

    /**
     * 操作流水号
     */
    private String operaTrace;

    /**
     * 结算账户信息
     */
    private AccInfo accInfo;

    /**
     * 结算账户信息2
     * 当商户类型（merMode）为企业商户并且结算账户为对私账户时，该字段必传；json 格式字符串
     */
    private AccInfoBak accInfoBak;

    /**
     * 图片信息
     */
    private List<PictureInfo> picInfoList;

    /**
     * 自定义信息
     */
    private CustomInfo customInfo;

    @Override
    public Class<MerchantSettleUpdateResponse> getResponseClass() {
        return MerchantSettleUpdateResponse.class;
    }
}
