/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.config;

import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.merchant.WechatJsApiConfigResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangmj
 * @version EasyPayMerchantInfoQueryRequest.java, v 0.1 2023-11-01 15:49 zhangmj
 */
@Data
public class EasyPayWeChatDirectoryConfigRequest extends EasyPayBizRequest<WechatJsApiConfigResponse> {

    private static final long serialVersionUID = 1809563351627653807L;

    /**
     * 子商户号(smid)
     */
    @NotBlank
    private String wechatId;

    /**
     * 授权目录
     */
    @NotBlank
    private String jsAPIPath;

    /**
     * 报文类型
     */
    private String messageType = "ALTERJSAPIPATH";

    @Override
    public Class<WechatJsApiConfigResponse> getResponseClass() {
        return WechatJsApiConfigResponse.class;
    }
}