/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.config;

import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.merchant.WechatAppIdConfigResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author zhangmj
 * @version EasyPayMerchantInfoQueryRequest.java, v 0.1 2023-11-01 15:49 zhangmj
 */
@Data
public class EasyPayWeChatAppIdConfigRequest extends EasyPayBizRequest<WechatAppIdConfigResponse> {

    private static final long serialVersionUID = 1809563351627653807L;

    /**
     * 子商户号(smid)
     */
    @NotBlank
    private String wechatId;

    /**
     * appId
     */
    @NotBlank
    private String appId;

    /**
     * 报文类型
     */
    private String messageType = "ALTERAPPID";

    @Override
    public Class<WechatAppIdConfigResponse> getResponseClass() {
        return WechatAppIdConfigResponse.class;
    }
}