/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhangmj
 * @version MerchantInfo.java, v 0.1 2023-11-02 21:05 zhangmj
 */
@Data
public class MerchantInfo implements Serializable {
    private static final long serialVersionUID = 6778469972393824743L;

    /**
     * 内部商户号，长度为15，不可变更
     **/
    @Length(max = 15, message = "merCode内部商户号长度不超过15")
    private String merCode;
    /**
     * 商户经营类型（0-企业 1-个体户 2-小微），长度为1，不可变更
     **/

    @Length(max = 1, message = "merMode商户经营类型长度不超过15")
    private String merMode;
    /**
     * 注册名称，长度为100，不可变更
     **/

    @Length(max = 100, message = "merName注册名称长度不超过100")
    private String merName;
    /**
     * 经营名称 (店名)，长度为50，可变更
     **/

    @Length(max = 50, message = "businName经营名称长度不超过50")
    private String businName;
    /**
     * 英文名称，长度为50，可变更
     **/
    @Length(max = 50, message = "merEngName英文名称长度不超过50")
    private String merEngName;
    /**
     * 商户类型(MCC)，银联定义的MCC编码，长度为4，不可变更
     **/

    @Length(max = 4, message = "merType商户类型(MCC)长度不超过4")
    private String merType;
    /**
     * 行业大类 0-标准、1-优惠、2-减免，长度为1，不可变更
     **/

    @Length(max = 1, message = "standardFlag行业大类长度不超过1")
    private String standardFlag;
    /**
     * 商户区域：银联地区码，长度为4，不可变更
     **/

    @Length(max = 1, message = "merArea商户区域长度不超过1")
    private String merArea;
    /**
     * 注册地址，长度为100，不可变更
     **/

    @Length(max = 100, message = "merAddr注册地址长度不超过100")
    private String merAddr;
    /**
     * 项目编号(易生提供)，用于商户分类统计，长度为6，可变更
     **/
    @Length(max = 6, message = "projectId项目编号长度不超过6")
    private String projectId;
    /**
     * 合作模式编号(易生提供)，用于合作方分润，长度为6，可变更
     **/
    @Length(max = 6, message = "projectBank合作模式编号长度不超过6")
    private String projectBank;
    /**
     * 营业时间：开始时间，格式：HHMM，长度为10，可变更
     **/

    @Length(max = 10, message = "businBegtime营业时间长度不超过10")
    private String businBegtime;
    /**
     * 营业时间：结束时间，格式：HHMM，长度为10，可变更
     **/

    @Length(max = 10, message = "businEndtime营业时间长度不超过10")
    private String businEndtime;
    /**
     * 公司规模：1：0-50人；2：50-100人；3:100以上，长度为1，可变更
     **/

    @Length(max = 1, message = "employeeNum公司规模长度不超过1")
    private String employeeNum;
    /**
     * 经营形态：02-普通店、01-连锁店，长度为2，可变更
     **/

    @Length(max = 2, message = "businForm经营形态长度不超过2")
    private String businForm;
    /**
     * 商户联接方式 1-直联(直联银联的商户)、0-间联（非直联银联的，默认为0），长度为1，可变更
     **/
    @Length(max = 1, message = "conMode经营形态长度不超过1")
    private String conMode;
    /**
     * 是否虚拟账户（0 — 银行账户（默认）， 1 — 虚拟账户），长度为1，不可变更
     **/
    @Length(max = 1, message = "payAccMode是否虚拟账户长度不超过1")
    private String payAccMode;
    /**
     * 是否易生清算：0 — 挂账， 1 — 正常清算商户，X—不清算，F—不结算，长度为1，可变更
     **/
    @Length(max = 1, message = "stlmType是否易生清算长度不超过1")
    private String stlmType;
    /**
     * 备注，长度为100，可变更
     **/
    @Length(max = 100, message = "merMark备注长度不超过100")
    private String merMark;
    /**
     * 商户状态 0 有效 X 注销 T 冻结，长度为1，不可变更
     **/
    @Length(max = 1, message = "state商户状态长度不超过1")
    private String state;
}