/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 功能信息
 * @author zhangmj
 * @version FuncInfo.java, v 0.1 2023-11-02 21:25 zhangmj
 */
@Data
public class FuncInfo implements Serializable {

    private static final long serialVersionUID = 910365241127083159L;
    /**
     * 微信：功能ID：2
     * 支付宝：功能ID:3
     * 银联二维码:功能ID：12
     * 银联营销业务:功能ID：14
     */
    @NotNull
    private Integer funcId;
    /**
     * 扣率（单位：%）
     */

    @Length(max = 50, message = "calcVal扣率长度不能超过50")
    private String calcVal;
    /**
     * 不需自动拆分 送：ZWOSZ1111111111
     */
    @Length(max = 50, message = "brandName不需自动拆分长度不能超过50")
    private String brandName;
    /**
     * 微信：空
     * 支付宝：支付宝PID
     */
    @Length(max = 50, message = "appid支付宝PID长度不能超过50")
    private String appid;
    /**
     * 微信：空
     * 支付宝：支付宝子商户号
     */
    @Length(max = 100, message = "alipayId支付宝子商户号长度不能超过100")
    private String alipayId;
    /**
     * 微信：微信公众号名称
     * 支付宝：空
     */
    @Length(max = 100, message = "pubName微信公众号名称长度不能超过100")
    private String pubName;
    /**
     * 微信：是否小程序：1-是；0-否（默认为0）
     * 支付宝：空
     */
    @Length(max = 1, message = "isMini是否小程序长度不能超过1")
    private String isMini;
    /**
     * 微信：微信子商户号
     * 支付宝：空
     */
    @Length(max = 100, message = "wechatId微信子商户号长度不能超过100")
    private String wechatId;
    /**
     * 微信：空
     * 支付宝：支付宝认证URL
     */
    @Length(max = 200, message = "alipayCertUrl支付宝认证URL长度不能超过200")
    private String alipayCertUrl;
    /**
     * 微信：微信认证URL
     * 支付宝：空
     */
    @Length(max = 200, message = "wechatCertUrl微信认证URL长度不能超过200")
    private String wechatCertUrl;
    /**
     * 开通状态：0-未开通；1-已开通；X-失败；3-处理中；9-商户已注销
     */
    @Length(max = 1, message = "state开通状态长度不能超过1")
    private String state;
    /**
     * 错误描述
     */
    @Length(max = 200, message = "retMsg错误描述长度不能超过200")
    private String retMsg;

    /**
     * 借记卡扣率方式 :1-封顶;0-不封顶
     */

    @Length(max = 1, message = "DStlmType借记卡扣率方式长度不能超过1")
    private String DStlmType;
    /**
     * 借记卡扣率（单位：%）
     */

    @Length(max = 12, message = "DCalcVal借记卡扣率长度不能超过12")
    private String DCalcVal;
    /**
     * 借记卡封顶金额（单位：元）,借记卡扣率方式封顶时必填
     */
    @Length(max = 8, message = "DStlmMaxAmt借记卡封顶金额长度不能超过8")
    private String DStlmMaxAmt;
    /**
     * 借记卡手续费最低值（单位：元）
     */

    @Length(max = 8, message = "DFeeLowLimit差值下限长度不能超过8")
    private String DFeeLowLimit;
    /**
     * 信用卡扣率（单位：%）
     */

    @Length(max = 12, message = "CCalcVal信用卡扣率长度不能超过12")
    private String CCalcVal;
    /**
     * 信用卡手续费最低值（单位：元）
     */

    @Length(max = 8, message = "CFeeLowLimit信用卡手续费最低值长度不能超过8")
    private String CFeeLowLimit;
}