/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhangmj
 * @version AccInfo.java, v 0.1 2023-11-02 21:23 zhangmj
 */
@Data
public class AccInfo implements Serializable {
    private static final long serialVersionUID = 7704917099408817274L;

    /**
     * 开户行名称
     */

    @Length(max = 100, message = "bankName开户行名称长度不能超过100")
    private String bankName;
    /**
     * 开户行行号
     */

    @Length(max = 20, message = "bankCode开户行行号长度不能超过20")
    private String bankCode;
    /**
     * 账号
     */

    @Length(max = 30, message = "account账号长度不能超过30")
    private String account;
    /**
     * 账户名称
     */

    @Length(max = 100, message = "accName账户名称长度不能超过100")
    private String accName;
    /**
     * 账户类型：00-个人(对私)；10-对公
     */

    @Length(max = 2, message = "accType账户类型长度不能超过2")
    private String accType;
    /**
     * 账户所属区域：区号
     */
    @Length(max = 8, message = "accArea账户所属区域长度不能超过8")
    private String accArea;
    /**
     * 证件类型：
     */
    @Length(max = 1, message = "legalType证件类型长度不能超过1")
    private String legalType;
    /**
     * 证件号
     */
    @Length(max = 42, message = "legalCode证件号长度不能超过42")
    private String legalCode;
    /**
     * 对私手机号
     */
    @Length(max = 20, message = "accPhone对私手机号长度不能超过20")
    private String accPhone;
}