/*
 * ailike.com
 * Copyright (C) 2022-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.trade;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhaoxumin
 * @version Identity.java, v 0.1 2023-10-27 14:35 zhaoxumin
 */
@Data
public class Identity implements Serializable {

    private static final long serialVersionUID = -6023832908352777948L;
    /**
     * 敏感信息 “{\”name\”:\”姓名\”, \”number\”:\”证件号码\”,\”mobile\”:\”手机号码，暂不校验\”}”
     */
    @NotBlank
    @JSONField(name = "encrypt_info")
    private String encryptInfo;

    /**
     * 是否强制校验付款人身份信息（仅支付宝） T:强制校验，F：不强制
     */
    @NotBlank
    @JSONField(name = "fix_buyer")
    private String fixBuyer;

    /**
     * 付款人-最小年龄（仅支付宝）
     */
    @NotBlank
    private String minage;

    /**
     * 是否强制校验身份信息（仅支付宝） T:强制校验，F：不强制
     */
    @NotBlank
    @JSONField(name = "need_check_info")
    private String needCheckInfo;

    /**
     * W:付款人-证件类型
     */
    @NotBlank
    private String type;

    /**
     * W:姓名
     */
    private String name;

    /**
     * W:证件号码
     */
    private String number;

    /**
     * 手机号码，暂不校验
     */
    private String mobile;
}