/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantInfoQueryResponse;
import com.fshows.easypay.sdk.response.merchant.info.AccInfo;
import com.fshows.easypay.sdk.response.merchant.info.AccInfoBak;
import com.fshows.easypay.sdk.response.merchant.info.CustomInfo;
import com.fshows.easypay.sdk.response.merchant.info.FuncInfo;
import com.fshows.easypay.sdk.response.merchant.info.LicInfo;
import com.fshows.easypay.sdk.response.merchant.info.MerchantInfo;
import com.fshows.easypay.sdk.response.merchant.info.PictureInfo;
import com.fshows.easypay.sdk.response.merchant.info.PlusInfo;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author zhubo
 * @version MerchantIncomeRequest.java, v 0.1 2023-11-04 11:09 zhubo
 */
@Data
public class MerchantIncomeRequest extends EasyPayBizRequest<MerchantInfoQueryResponse> {
    private static final long serialVersionUID = -329204022746823218L;

    /**
     * 回调url
     */
    private String backUrl;

    /**
     * 商家信息
     */
    private MerchantInfo merchantInfo;

    /**
     * 附加信息
     */
    private PlusInfo plusInfo;

    /**
     * 营业执照信息
     */
    private LicInfo licenseInfo;

    /**
     * 结算账户信息
     */
    private AccInfo accInfo;

    /**
     * 结算账户信息2
     * 当商户类型（merMode）为企业商户并且结算账户为对私账户时，该字段必传；json 格式字符串
     */
    private AccInfoBak accInfoBak;

    /**
     * 功能信息
     */
    private FuncInfo funcInfo;

    /**
     * 产品信息
     * json 格式字符串 (list) 特殊场景下使用
     */
    private List<String> prodList;

    /**
     * 图片信息
     */
    private List<PictureInfo> picInfoList;

    /**
     * 该字段为机构上送的操作流水号，机构唯一；用于查询操作结果；
     */
    @NotBlank
    @Length(max = 20, message = "operaTrace操作流水号不能为空")
    private String operaTrace;

    /**
     * 默认0； 0 否 1 使用，是否使用易生签约流程，当使用易生签约流程时，需要调用签约接口否则无法审核， 备注：字符串类型
     * 固定传为1使用
     */
    private String isContract;

    /**
     * json 格式字符串，需和易生约定特殊使用
     */
    private CustomInfo customInfo;

    @Override
    public Class<MerchantInfoQueryResponse> getResponseClass() {
        return MerchantInfoQueryResponse.class;
    }
}
