/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantUpdateResponse;
import com.fshows.easypay.sdk.response.merchant.info.CustomInfo;
import com.fshows.easypay.sdk.response.merchant.info.LicInfo;
import com.fshows.easypay.sdk.response.merchant.info.MerchantInfo;
import com.fshows.easypay.sdk.response.merchant.info.PictureInfo;
import com.fshows.easypay.sdk.response.merchant.info.PlusInfo;
import lombok.Data;

import java.util.List;

/**
 * @author zhubo
 * @version MerchantUpdateRequest.java, v 0.1 2023-11-04 13:54 zhubo
 */
@Data
public class MerchantUpdateRequest extends EasyPayBizRequest<MerchantUpdateResponse> {
    private static final long serialVersionUID = 4587772878278065309L;

    /**
     * 回调url
     */
    private String backUrl;

    /**
     * 商家信息
     */
    private MerchantInfo merchantInfo;

    /**
     * 附加信息
     */
    private PlusInfo plusInfo;

    /**
     * 营业执照信息
     */
    private LicInfo licenseInfo;

    /**
     * 产品信息
     * json 格式字符串 (list) 特殊场景下使用
     */
    private List<String> prodList;

    /**
     * 图片信息
     */
    private List<PictureInfo> picInfoList;

    /**
     * json 格式字符串，需和易生约定特殊使用
     */
    private CustomInfo customInfo;

    @Override
    public Class<MerchantUpdateResponse> getResponseClass() {
        return MerchantUpdateResponse.class;
    }
}
