/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.easypay.sdk.client;

import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.base.EasyPayMerchantBizResponse;

/**
 * @author zhaoxumin
 * @version EasyPayBaseClient.java, v 0.1 2023-10-27 13:32
 */
public interface EasyPayMerchantClient {

    /**
     * 请求易生接口
     *
     * @param request          请求参数
     * @param easyPayApiDefinition 方法枚举
     * @param <R>              返参
     * @return UmBaseResponse
     * <p>
     * EasyPayApiDefinition api方法请参考下列API枚举
     */
    <R, T> EasyPayMerchantBizResponse<T> execute(EasyPayBizRequest<R> request, EasyPayApiDefinition easyPayApiDefinition) throws EasyPayException;

    /**
     * 请求易生接口（子服务商）
     *
     * @param request
     * @param easyPayApiDefinition
     * @param subAppId
     * @return
     * @param <R>
     * @throws EasyPayException
     */
    <R, T> EasyPayMerchantBizResponse<T> execute(EasyPayBizRequest<R> request, EasyPayApiDefinition easyPayApiDefinition, String subAppId) throws EasyPayException;

}
