/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.util;

import cn.hutool.core.util.StrUtil;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.util.ValidateResult;
import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidateUtil {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> ValidateResult validate(T object, Class<?> ... classes) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setResult(true);
        Set constraintViolations = VALIDATOR.validate(object, (Class[])classes);
        ConstraintViolation constraintViolation = (ConstraintViolation)Iterables.getFirst((Iterable)constraintViolations, null);
        if (constraintViolation != null) {
            validateResult.setResult(false);
            validateResult.setParamName(CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, constraintViolation.getPropertyPath().toString()));
            validateResult.setMsg(constraintViolation.getMessage());
        }
        return validateResult;
    }

    public static <T> void validateWithThrow(T request, Class<?> ... classes) throws CcbPayApiException {
        ValidateResult validate = ValidateUtil.validate(request, classes);
        if (!validate.isResult()) {
            throw new CcbPayApiException(StrUtil.format((CharSequence)"\u9519\u8bef\u53c2\u6570\uff0cparam={}\uff0cmsg={}{}", (Object[])new Object[]{validate.getParamName(), validate.getParamName(), validate.getMsg()}));
        }
    }

    public static void notNull(Object obj, String msg) throws CcbPayApiException {
        if (obj == null) {
            throw new CcbPayApiException(msg);
        }
    }

    public static void check(boolean bo, String msg) throws CcbPayApiException {
        if (!bo) {
            throw new CcbPayApiException(msg);
        }
    }
}

