/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.wlpt;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wangqilei
 * @version CcbOrdeRefundResponse.java, v 0.1 2024-04-25 11:37 AM wangqilei
 */
@Data
public class CcbRefundResponse extends CcbPayBaseResponse {
    private static final long serialVersionUID = 4439100092595484613L;
    /**
     * 同请求报文中的序列号
     * (选填)
     */
    private String requestSn;

    /**
     * 同请求报文中的商户号
     * (选填)
     */
    private String custId;

    /**
     * 同请求报文中的交易码
     * (选填)
     */
    private String txCode;

    /**
     * 交易响应码
     * (选填)
     */
    private String returnCode;

    /**
     * 交易响应信息
     * (选填)
     */
    private String returnMsg;

    /**
     * 语言
     * (选填)
     */
    private String language;

    /**
     * 明细
     */
    private CcbRefundInfo txInfo;


    @Data
    public static class CcbRefundInfo {
        /**
         * 订单号
         * (选填)
         */
        private String orderNum;

        /**
         * 订单金额
         * (选填)
         */
        private BigDecimal payAmount;

        /**
         * 退款金额
         * (选填)
         */
        private BigDecimal amount;

        /**
         * 退款方式，ZFB:支付宝;CFT:微信;其他返回空
         * (选填)
         */
        private String payMode;

        /**
         * 申请退款总金额，PAY_MODE=ZFB或CFT时有效，否则返回空值
         * (选填)
         */
        private BigDecimal refundFee;

        /**
         * 商户实际退款金额，PAY_MODE=ZFB或CFT时有效，否则返回空值
         * (选填)
         */
        private BigDecimal mrchAccentramt;

        /**
         * 买家退款金额，PAY_MODE=ZFB或CFT时有效，否则返回空值
         * (选填)
         */
        private BigDecimal cashRefundFee;

        /**
         * 代金券退款，PAY_MODE=CFT时有效，否则返回空值
         * (选填)
         */
        private BigDecimal couponRefundFee;

        /**
         * 平台优惠退款金额，PAY_MODE=ZFB时有效，否则返回空值
         * (选填)
         */
        private BigDecimal presentRefundDiscount;

        /**
         * 商家优惠退款金额，PAY_MODE=ZFB时有效，否则返回空值
         * (选填)
         */
        private BigDecimal presentRefundMdiscountAmount;

        /**
         * 交易金额，折后金额，龙支付优惠退货时返回实际退卡金额
         * (选填)
         */
        private BigDecimal txnamt;

        /**
         * 联机处理标志一位图编码，龙支付优惠退货时返回权益位图编码
         * (选填)
         */
        private String onlnpcsgind1BmpEcd;
    }
}