/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.wlpt;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;

/**
 * @author wangqilei
 * @version CcbStatmentFileResponse.java, v 0.1 2024-04-28 10:10 AM wangqilei
 */
@Data
public class CcbOrderFileResponse extends CcbPayBaseResponse {
    /**
     * 同请求报文中的序列号
     * (选填)
     */
    private String requestSn;

    /**
     * 同请求报文中的商户号
     * (选填)
     */
    private String custId;

    /**
     * 同请求报文中的交易码
     * (选填)
     */
    private String txCode;

    /**
     * 交易响应码
     * (选填)
     */
    private String returnCode;

    /**
     * 交易响应信息
     * (选填)
     */
    private String returnMsg;

    /**
     * 语言
     * (选填)
     */
    private String language;

    /**
     * 明细
     */
    private CcbOrderFileInfo txInfo;

    @Data
    public static class CcbOrderFileInfo {
        /**
         * 文件名，通过6W0111交易进行文件下载
         */
        private String fileName;

        /**
         * 提示信息
         */
        private String notice;
    }
}