/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.ccbpay.response.trade.order;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import org.hibernate.validator.constraints.Length;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 *
 *
 * @author
 * @version CcbOrderCloseResponse.java, v 0.1 2022-07-05 11:57:50
 */
@Data
public class CcbOrderCloseResponse  extends CcbPayBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555357859717L;


    /**
     * 订单结果
     * Y：成功N：失败U：不确定（交易超时，建议通过查询接口确认订单状态）
     *
     * 示例：Y
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "result长度不能超过1")
    @JSONField(name = "RESULT")
    private String result;

    /**
     * 订单号
     * 从请求参数中获得
     *
     * 示例：20180906101102
     * (特殊必填)
     */
    @Length(max = 30, message = "orderid长度不能超过30")
    @JSONField(name = "ORDERID")
    private String orderid;

    /**
     * 是否重调
     * 是否需要继续调用订单关闭交易Y：需要N：不需要
     *
     * 示例：N
     * (特殊必填)
     */
    @Length(max = 1, message = "recall长度不能超过1")
    @JSONField(name = "RECALL")
    private String recall;

    /**
     * 错误码
     * 报错时返回
     *
     * 示例：9001
     * (特殊必填)
     */
    @Length(max = 12, message = "errcode长度不能超过12")
    @JSONField(name = "ERRCODE")
    private String errcode;

    /**
     * 错误信息
     * 报错时返回
     *
     * 示例：未查询到该笔订单
     * (特殊必填)
     */
    @Length(max = 80, message = "errmsg长度不能超过80")
    @JSONField(name = "ERRMSG")
    private String errmsg;

    /**
     * 签名
     * 签名串，签名源文格式见下方说明，验签方法详见[4.2.返回报文验签方法]
     *
     * 示例：20924b4c8018c591c62d05fffaa32c0009613050c2b739002b0228e74
     * (特殊必填)
     */
    @Length(max = 200, message = "sign长度不能超过200")
    @JSONField(name = "SIGN")
    private String sign;

}