/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.request.base;

import com.fshows.ccbpay.enums.trade.CcbPayTradeApiDefinitionEnum;
import com.fshows.ccbpay.request.base.CcbPayBizRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangqilei
 * @version CcbPayCommonRequest.java, v 0.1 2024-04-26 3:32 PM wangqilei
 */
@Data
public class CcbWlptCommonRequest<T> extends CcbPayBizRequest<CcbPayBaseResponse, CcbPayTradeApiDefinitionEnum> {
    private static final long serialVersionUID = 5714244913340867655L;

    /**
     * 只可以使用数字，请求报文中的序列号
     * (必填)
     */
    @NotBlank
    @Length(max = 16, message = "requestSn长度不能超过16")
    private String requestSn;

    /**
     * 字符型char，网银商户号，同请求报文中的商户号
     * (必填)
     */
    @Length(max = 21, message = "custId长度不能超过21")
    private String custId;

    /**
     * 20051210后必须使用，操作员号
     * (必填)
     */
    @Length(max = 20, message = "userId长度不能超过20")
    private String userId;

    /**
     * 操作员密码
     * (必填)
     */
    @Length(max = 32, message = "password长度不能超过32")
    private String password;

    /**
     * 交易请求码，同请求报文中的交易码
     * (必填)
     */
    @Length(max = 6, message = "txCode长度不能超过6")
    private String txCode;

    /**
     * CN，交易语言
     * (必填)
     */
    @Length(max = 2, message = "language长度不能超过2")
    private String language;

    /**
     * 详情
     */
    @NotNull(message = "txInfo不能为空")
    private T txInfo;
}