package com.fshows.ccbpay.enums.base;

import org.apache.commons.lang3.StringUtils;

/**
 * 建行API类型（不同的类型是一套单独的加签验签方式）
 *
 * @author liluqing
 * @version CcbApiTypeEnum.java, v 0.1 2022-07-05 17:07 liluqing
 */
public enum CcbApiTypeEnum {

    DIRECT_CONNECT("建行银企直连接口", "DIRECT_CONNECT"),
    OUT_CONNECT_PLATFORM("建行外连平台接口", "OUT_CONNECT_PLATFORM"),
    ;

    private String name;
    private String value;

    CcbApiTypeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static CcbApiTypeEnum getByValue(String value) {
        CcbApiTypeEnum[] valueList = CcbApiTypeEnum.values();
        for (CcbApiTypeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}