/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import cn.hutool.http.HttpRequest;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.CcbPayHttpResult;

import java.io.IOException;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class DefaultHttpRequestImpl implements IHttpRequest {

    @Override
    public CcbPayHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws IOException {
//        String body = FsHttpUtil.postString(
//                url,
//                requestBody,
//                apiClientConfig.getCharset(),
//                CommonConstant.JSON_CONTENT_TYPE,
//                apiClientConfig.getConnectionTimeout(),
//                apiClientConfig.getReadTimeout(),
//                null);
//
//        UnionPayHttpResult unionPayHttpResult = new UnionPayHttpResult();
//        unionPayHttpResult.setBody(body);
//        return unionPayHttpResult;
        String resBody = HttpRequest.post(url)
                .body(requestBody)
                .timeout(apiClientConfig.getConnectionTimeout())
                .execute().body();
        CcbPayHttpResult ccbPayHttpResult = new CcbPayHttpResult();
        ccbPayHttpResult.setBody(resBody);
        return ccbPayHttpResult;
    }
}