/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.http.HttpRequest;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.CcbPayHttpResult;
import com.fshows.ccbpay.client.base.IHttpRequest;

import java.io.IOException;

/**
 * @author liubo
 * @version CcbPayHttpRequestImpl.java, v 0.1 2024-05-07-10:14 上午 liubo
 */
public class CcbPayHttpRequestImpl implements IHttpRequest {

    @Override
    public CcbPayHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws IOException {

        String req = url +"?"+requestBody;

        String resBody = HttpRequest.post(req)
                .timeout(apiClientConfig.getConnectionTimeout())
                .execute().body();
        CcbPayHttpResult ccbPayHttpResult = new CcbPayHttpResult();
        ccbPayHttpResult.setBody(resBody);
        return ccbPayHttpResult;
    }
}