/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.ccbpay.client.base;

import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;

/**
 * @author liluqing
 * @version Signer.java, v 0.1 2022-03-02 7:51 PM liluqing
 */
public interface ISigner<T extends CcbPayBaseRequest, R extends CcbPayBaseResponse> {

    /**
     * 加签
     *
     * @param request       签名参数
     * @param apiClientConfig api客户端加签配置
     * @return
     */
    String sign(T request, ApiClientConfig apiClientConfig) throws CcbPayApiException;

    /**
     * 验签
     *
     * @param response       响应结果
     * @param apiClientConfig api客户端加签配置
     * @return
     */
    Boolean verifySign(R response, ApiClientConfig apiClientConfig) throws CcbPayApiException;
}
