/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.alibaba.fastjson.JSONObject;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.client.impl.AbstractCcbPayApiClientImpl;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcbJsapiPayApiClientImp
extends AbstractCcbPayApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(CcbJsapiPayApiClientImp.class);

    public CcbJsapiPayApiClientImp(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return this.doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        request.setPub(this.apiClientConfig.getCcbPayPublicKey().substring(this.apiClientConfig.getCcbPayPublicKey().length() - 30));
        return request;
    }

    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException, IOException {
        StringBuilder requestValue = new StringBuilder();
        requestValue.append("CCB_IBSVersion=V6&");
        Map<String, String> reqMap = request.getReqMap();
        String reqValue = CcbJsapiPayApiClientImp.buildReq(reqMap, this.apiClientConfig.getCharset());
        Digester md5 = new Digester(DigestAlgorithm.MD5);
        String mac = md5.digestHex(reqValue).toLowerCase();
        requestValue.append(reqValue.replaceAll("&PUB=" + this.apiClientConfig.getCcbPayPublicKey().substring(this.apiClientConfig.getCcbPayPublicKey().length() - 30), ""));
        requestValue.append("&MAC=").append(mac);
        return requestValue.toString();
    }

    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return (CcbPayBaseResponse)JSONObject.parseObject((String)resBody, tradeApiDefinitionEnum.getResponseClass());
    }

    public static String buildReq(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean isFirst = true;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!isFirst) {
                query.append("&");
            } else {
                isFirst = false;
            }
            if (name.equals("proInfo")) {
                query.append(name).append("=").append(StrUtil.isNotEmpty((CharSequence)value) ? URLEncoder.encode(value, charset) : "");
                continue;
            }
            query.append(name).append("=").append(value);
        }
        return query.toString();
    }
}

