/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.client.impl.AbstractCcbPayApiClientImpl;
import com.fshows.ccbpay.client.impl.DefaultSignerImpl;
import com.fshows.ccbpay.client.impl.WlptRequestImpl;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.CcbRequestUtils;
import com.fshows.ccbpay.util.LogUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcbWlptApiClientImpl
extends AbstractCcbPayApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(CcbWlptApiClientImpl.class);

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        this(apiClientConfig, new WlptRequestImpl(), new DefaultSignerImpl());
    }

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest bizRequest, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return bizRequest;
    }

    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = CcbRequestUtils.toMap(request);
        HashMap<String, String> newMap = new HashMap<String, String>();
        requstMap.entrySet().stream().forEach(entry -> {
            String key = (String)entry.getKey();
            String upKey = Arrays.stream(key.split("_")).map(String::toUpperCase).collect(Collectors.joining("_"));
            newMap.put(upKey, (String)entry.getValue());
        });
        return CcbRequestUtils.generateXml(newMap);
    }

    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        try {
            Map<String, String> resMap = CcbRequestUtils.getMapFromXML(resBody);
            return (CcbPayBaseResponse)CcbRequestUtils.getObjectFromMap(resMap, tradeApiDefinitionEnum.getResponseClass());
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccb-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, resBody);
            return null;
        }
    }
}

