/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.web.controller.system;

import com.alibaba.dubbo.config.annotation.Reference;
import com.fshows.auth.base.biz.system.UserSystemBiz;
import com.fshows.auth.base.request.system.GetUserSystemByUserIdReq;
import com.fshows.auth.base.request.system.RedirectValidateReq;
import com.fshows.auth.base.response.auth.UserInfoRes;
import com.fshows.auth.common.util.BeanCopierUtil;
import com.fshows.auth.facade.api.UserSystemService;
import com.fshows.auth.facade.result.ApiResponse;
import com.fshows.auth.facade.vo.system.LogoutVO;
import com.fshows.auth.web.dto.system.LogoutDTO;
import com.fshows.auth.web.dto.system.RedirectValidateDTO;
import com.fshows.auth.web.dto.system.SystemByUnionidDTO;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.SessionAttribute;

@RestController
@RequestMapping(value={"/system"})
public class UserSystemController {
    private static final Logger log = LoggerFactory.getLogger(UserSystemController.class);
    @Reference
    private UserSystemService userSystemService;
    @Autowired
    private UserSystemBiz userSystemBiz;
    @Autowired
    private HttpServletRequest request;

    @PostMapping(value={"/getUserSystemList"})
    public ApiResponse getUserSystemList(@Valid @RequestBody SystemByUnionidDTO dto, @SessionAttribute(value="login_user") UserInfoRes userInfoRes) {
        GetUserSystemByUserIdReq req = (GetUserSystemByUserIdReq)BeanCopierUtil.copy((Object)((Object)dto), GetUserSystemByUserIdReq.class);
        req.setUnionId(userInfoRes.getUnionid());
        return ApiResponse.success((Object)this.userSystemBiz.getUserSystemList(req));
    }

    @PostMapping(value={"/redirectValidate"})
    public ApiResponse redirectValidate(@Valid @RequestBody RedirectValidateDTO dto, @SessionAttribute(value="login_user") UserInfoRes userInfoRes) {
        ApiResponse apiResponse = ApiResponse.success();
        RedirectValidateReq req = (RedirectValidateReq)BeanCopierUtil.copy((Object)dto, RedirectValidateReq.class);
        req.setUnionId(userInfoRes.getUnionid());
        this.userSystemBiz.redirectValidate(req);
        return apiResponse;
    }

    @PostMapping(value={"/logout"})
    public ApiResponse logout(@Valid @RequestBody LogoutDTO dto) {
        LogoutVO vo = (LogoutVO)BeanCopierUtil.copy((Object)dto, LogoutVO.class);
        this.request.getSession().removeAttribute("login_user");
        return this.userSystemService.logout(vo);
    }

    @PostMapping(value={"/systemLogout"})
    public ApiResponse systemLogout(@SessionAttribute(value="login_user") UserInfoRes userInfoRes) {
        String token = userInfoRes.getToken();
        String unionid = userInfoRes.getUnionid();
        this.userSystemBiz.systemLogout(unionid, token);
        this.request.getSession().removeAttribute("login_user");
        return ApiResponse.success();
    }
}

