/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.web.controller.auth;

import com.alibaba.dubbo.config.annotation.Reference;
import com.fshows.auth.base.biz.auth.AuthBiz;
import com.fshows.auth.base.request.auth.GetUserByCodeReq;
import com.fshows.auth.common.util.BeanCopierUtil;
import com.fshows.auth.facade.api.AuthService;
import com.fshows.auth.facade.result.ApiResponse;
import com.fshows.auth.facade.vo.auth.ApplyAuthVO;
import com.fshows.auth.web.dto.auth.ApplyAuthDTO;
import com.fshows.auth.web.dto.auth.GetQrCodeUrlDTO;
import com.fshows.auth.web.dto.auth.GetUserByCodeDTO;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"auth"})
public class AuthController {
    @Reference
    private AuthService authService;
    @Autowired
    private AuthBiz authBiz;

    @RequestMapping(value={"/getQrCodeUrl"}, method={RequestMethod.POST})
    public ApiResponse getQrCodeUrl(@RequestBody GetQrCodeUrlDTO dto) {
        String qrCodeUrl = this.authBiz.getQrCodeUrl(dto.getRedirectUrl());
        HashMap map = Maps.newHashMap();
        map.put("qrUrl", qrCodeUrl);
        return ApiResponse.success((Object)map);
    }

    @RequestMapping(value={"/applyAuth"}, method={RequestMethod.POST})
    public ApiResponse applyAuth(@RequestBody ApplyAuthDTO dto) {
        ApplyAuthVO vo = (ApplyAuthVO)BeanCopierUtil.copy((Object)dto, ApplyAuthVO.class);
        return this.authService.applyAuth(vo);
    }

    @RequestMapping(value={"/getUserByCode"}, method={RequestMethod.POST})
    public ApiResponse getUserByCode(@Valid @RequestBody GetUserByCodeDTO dto) {
        GetUserByCodeReq req = (GetUserByCodeReq)BeanCopierUtil.copy((Object)dto, GetUserByCodeReq.class);
        return ApiResponse.success((Object)this.authBiz.getUserByCode(req));
    }
}

