/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util.dingding;

import com.alibaba.fastjson.JSON;
import com.fshows.auth.common.util.dingding.DingMessage;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DingTextMessage
implements DingMessage {
    private String text;
    private List<String> atMobiles;
    private boolean isAtAll;

    public DingTextMessage(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public List<String> getAtMobiles() {
        return this.atMobiles;
    }

    public void setAtMobiles(List<String> atMobiles) {
        this.atMobiles = atMobiles;
    }

    public boolean isAtAll() {
        return this.isAtAll;
    }

    public void setIsAtAll(boolean isAtAll) {
        this.isAtAll = isAtAll;
    }

    @Override
    public String toJsonString() {
        HashMap items = Maps.newHashMap();
        items.put("msgtype", "text");
        HashMap textContent = Maps.newHashMap();
        if (StringUtils.isBlank((CharSequence)this.text)) {
            throw new IllegalArgumentException("text should not be blank");
        }
        textContent.put("content", this.text);
        items.put("text", textContent);
        HashMap atItems = Maps.newHashMap();
        if (this.atMobiles != null && !this.atMobiles.isEmpty()) {
            atItems.put("atMobiles", this.atMobiles);
        }
        if (this.isAtAll) {
            atItems.put("isAtAll", this.isAtAll);
        }
        items.put("at", atItems);
        return JSON.toJSONString((Object)items);
    }
}

