/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util.dingding;

import com.alibaba.fastjson.JSON;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiDepartmentListRequest;
import com.dingtalk.api.request.OapiExtcontactCreateRequest;
import com.dingtalk.api.request.OapiExtcontactDeleteRequest;
import com.dingtalk.api.request.OapiExtcontactGetRequest;
import com.dingtalk.api.request.OapiExtcontactListRequest;
import com.dingtalk.api.request.OapiExtcontactListlabelgroupsRequest;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.request.OapiUserGetUseridByUnionidRequest;
import com.dingtalk.api.request.OapiUserListbypageRequest;
import com.dingtalk.api.response.OapiDepartmentListResponse;
import com.dingtalk.api.response.OapiExtcontactCreateResponse;
import com.dingtalk.api.response.OapiExtcontactDeleteResponse;
import com.dingtalk.api.response.OapiExtcontactGetResponse;
import com.dingtalk.api.response.OapiExtcontactListResponse;
import com.dingtalk.api.response.OapiExtcontactListlabelgroupsResponse;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.dingtalk.api.response.OapiUserGetUseridByUnionidResponse;
import com.dingtalk.api.response.OapiUserListbypageResponse;
import com.fshows.auth.common.config.property.DingDingProperty;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DingDingClient {
    private static final Logger log = LoggerFactory.getLogger(DingDingClient.class);
    @Autowired
    private DingDingProperty dingDingProperty;

    public String getAccessToken() throws RuntimeException {
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
            OapiGettokenRequest request = new OapiGettokenRequest();
            request.setAppkey(this.dingDingProperty.getMinuteAppKey());
            request.setAppsecret(this.dingDingProperty.getMinuteAppSecret());
            request.setHttpMethod("GET");
            OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            String accessToken = response.getAccessToken();
            return accessToken;
        }
        catch (ApiException e) {
            log.error("getAccessToken failed", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public OapiSnsGetuserinfoBycodeResponse getUserByCode(String code) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
        OapiSnsGetuserinfoBycodeRequest req = new OapiSnsGetuserinfoBycodeRequest();
        req.setTmpAuthCode(code);
        OapiSnsGetuserinfoBycodeResponse response = null;
        try {
            response = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)req, this.dingDingProperty.getMoveAppKey(), this.dingDingProperty.getMoveAppSecret());
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiUserGetUseridByUnionidResponse getUserContactType(String unionid, String token) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/getUseridByUnionid");
        OapiUserGetUseridByUnionidRequest requestParam = new OapiUserGetUseridByUnionidRequest();
        requestParam.setUnionid(unionid);
        requestParam.setHttpMethod("GET");
        OapiUserGetUseridByUnionidResponse response = null;
        try {
            response = (OapiUserGetUseridByUnionidResponse)client.execute((TaobaoRequest)requestParam, token);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        System.out.println(JSON.toJSONString((Object)response));
        return response;
    }

    public OapiUserGetResponse getUserByUserid(String userid, String token) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/get");
        OapiUserGetRequest request = new OapiUserGetRequest();
        request.setUserid(userid);
        request.setHttpMethod("GET");
        OapiUserGetResponse response = null;
        try {
            response = (OapiUserGetResponse)client.execute((TaobaoRequest)request, token);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiDepartmentListResponse getDepartmentList(String departmentId, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/department/list");
        OapiDepartmentListRequest request = new OapiDepartmentListRequest();
        request.setId(departmentId);
        request.setHttpMethod("GET");
        OapiDepartmentListResponse response = null;
        try {
            response = (OapiDepartmentListResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiUserListbypageResponse getUserDetailListByDepartment(Long departmentId, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/listbypage");
        OapiUserListbypageRequest request = new OapiUserListbypageRequest();
        request.setDepartmentId(departmentId);
        request.setOffset(Long.valueOf(0L));
        request.setSize(Long.valueOf(50L));
        request.setOrder("entry_desc");
        request.setHttpMethod("GET");
        OapiUserListbypageResponse response = null;
        try {
            response = (OapiUserListbypageResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiExtcontactListlabelgroupsResponse getExtContactLabelList(String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/extcontact/listlabelgroups");
        OapiExtcontactListlabelgroupsRequest request = new OapiExtcontactListlabelgroupsRequest();
        request.setOffset(Long.valueOf(0L));
        request.setSize(Long.valueOf(20L));
        OapiExtcontactListlabelgroupsResponse response = null;
        try {
            response = (OapiExtcontactListlabelgroupsResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiExtcontactListResponse getExtContactList(String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/extcontact/list");
        OapiExtcontactListRequest request = new OapiExtcontactListRequest();
        request.setOffset(Long.valueOf(0L));
        request.setSize(Long.valueOf(20L));
        OapiExtcontactListResponse response = null;
        try {
            response = (OapiExtcontactListResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiExtcontactGetResponse getExtContactDetail(String userId, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/extcontact/get");
        OapiExtcontactGetRequest request = new OapiExtcontactGetRequest();
        request.setUserId(userId);
        OapiExtcontactGetResponse response = null;
        try {
            response = (OapiExtcontactGetResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiExtcontactCreateResponse addExtContact(String userid, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/extcontact/create");
        OapiExtcontactCreateRequest request = new OapiExtcontactCreateRequest();
        OapiExtcontactCreateRequest.OpenExtContact openExtContact = new OapiExtcontactCreateRequest.OpenExtContact();
        openExtContact.setTitle("\u9690\u58eb");
        openExtContact.setLabelIds(Arrays.asList(2007044L));
        openExtContact.setShareDeptIds(Arrays.asList(new Long[0]));
        openExtContact.setAddress("\u5730\u5740");
        openExtContact.setRemark("\u5907\u6ce8");
        openExtContact.setFollowerUserId(userid);
        openExtContact.setName("allen");
        openExtContact.setStateCode("86");
        openExtContact.setCompanyName("allen\u516c\u53f8");
        openExtContact.setShareUserIds(Arrays.asList(new String[0]));
        openExtContact.setMobile("18506575738");
        request.setContact(openExtContact);
        OapiExtcontactCreateResponse response = null;
        try {
            response = (OapiExtcontactCreateResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }

    public OapiExtcontactDeleteResponse delExtContact(String userid, String accessToken) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/extcontact/delete");
        OapiExtcontactDeleteRequest request = new OapiExtcontactDeleteRequest();
        request.setUserId(userid);
        OapiExtcontactDeleteResponse response = null;
        try {
            response = (OapiExtcontactDeleteResponse)client.execute((TaobaoRequest)request, accessToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }
}

