/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.redis;

import com.fshows.auth.common.config.property.RedisConfigProperty;
import javax.annotation.Resource;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class JedisConfig
extends CachingConfigurerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JedisConfig.class);
    public static final int EXPIRE_TIME = 1800;
    @Resource
    private RedisConfigProperty redisConfigProperty;

    @Bean(name={"jedisPoolConfig"})
    @ConfigurationProperties(prefix="spring.redis.pool-config")
    public JedisPoolConfig getRedisConfig() {
        return new JedisPoolConfig();
    }

    @Bean(name={"jedisPool"})
    public JedisPool jedisPool(@Qualifier(value="jedisPoolConfig") JedisPoolConfig jedisPoolConfig) {
        LOGGER.info("Jedis Pool build start ");
        String host = this.redisConfigProperty.getHost();
        Integer timeout = this.redisConfigProperty.getTimeout();
        int port = this.redisConfigProperty.getPort();
        String password = this.redisConfigProperty.getPassword();
        int database = this.redisConfigProperty.getDatabase();
        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)jedisPoolConfig, host, port, timeout.intValue(), password, database);
        LOGGER.info("Jedis Pool build success  host = {} , port = {} ", (Object)host, (Object)port);
        return jedisPool;
    }
}

