/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpUtil.class);
    private static final String ENCODING = "UTF-8";
    private static final Integer DEFAULT_TIME_OUT = 10000;
    private static final String HEADER_CONTENT_TYPE_KEY = "Content-Type";
    private static final String HEADER_CONTENT_TYPE_VALUE = "application/json";
    private static PoolingHttpClientConnectionManager connManager;

    private static CloseableHttpClient getHttpClient(Integer timeOut) {
        if (timeOut == null) {
            timeOut = DEFAULT_TIME_OUT;
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).setSocketTimeout(timeOut.intValue()).build();
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount >= 1) {
                    return false;
                }
                if (exception instanceof NoHttpResponseException) {
                    return true;
                }
                if (exception instanceof SSLHandshakeException) {
                    return false;
                }
                if (exception instanceof InterruptedIOException) {
                    return true;
                }
                if (exception instanceof UnknownHostException) {
                    return false;
                }
                if (exception instanceof ConnectTimeoutException) {
                    return false;
                }
                if (exception instanceof SSLException) {
                    return false;
                }
                HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                HttpRequest request = clientContext.getRequest();
                return !(request instanceof HttpEntityEnclosingRequest);
            }
        };
        CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultRequestConfig(requestConfig).build();
        return httpClient;
    }

    private static SSLContext getSSLContext(boolean isDeceive, File creFile, String crePwd) throws Exception {
        SSLContext sslContext = null;
        if (isDeceive) {
            sslContext = SSLContext.getInstance("SSLv3");
            X509TrustManager x509TrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }
            };
            sslContext.init(null, new TrustManager[]{x509TrustManager}, null);
        } else if (null != creFile && creFile.length() > 0L) {
            if (null != crePwd) {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(new FileInputStream(creFile), crePwd.toCharArray());
                sslContext = SSLContexts.custom().loadTrustMaterial(keyStore, (TrustStrategy)new TrustSelfSignedStrategy()).build();
            } else {
                throw new SSLHandshakeException("httpclient SSL\u914d\u7f6e\u5f02\u5e38:\u6574\u6570\u5bc6\u7801\u4e3a\u7a7a");
            }
        }
        return sslContext;
    }

    public static String post(String url, Map<String, String> params, Integer timeout) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        HashMap form = Maps.newHashMapWithExpectedSize((int)8);
        if (null != params) {
            for (String s : params.keySet()) {
                form.put(s, params.get(s) == null ? null : params.get(s));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpUtil.covertParams2NVPS(form), ENCODING));
        }
        return HttpUtil.getResult((HttpRequestBase)httpPost, url, timeout, form);
    }

    public static String postExcludeHeader(String url, Map<String, String> params) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        HashMap form = Maps.newHashMapWithExpectedSize((int)8);
        if (null != params) {
            for (String s : params.keySet()) {
                form.put(s, params.get(s) == null ? null : params.get(s));
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(HttpUtil.covertParams2NVPS(form), ENCODING));
        }
        return HttpUtil.getResult((HttpRequestBase)httpPost, url, null, form);
    }

    public static String post(String url, Map<String, String> params) throws Exception {
        return HttpUtil.post(url, params, null);
    }

    public static String postJson(String url, String body, Integer timeout) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(HEADER_CONTENT_TYPE_KEY, HEADER_CONTENT_TYPE_VALUE);
        httpPost.setEntity((HttpEntity)new StringEntity(body, ENCODING));
        return HttpUtil.getResult((HttpRequestBase)httpPost, url, timeout, body);
    }

    public static String postJson(String url, String body) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(HEADER_CONTENT_TYPE_KEY, HEADER_CONTENT_TYPE_VALUE);
        httpPost.setEntity((HttpEntity)new StringEntity(body, ENCODING));
        return HttpUtil.getResult((HttpRequestBase)httpPost, url, null, body);
    }

    public static String get(String url) {
        HttpGet httpGet = new HttpGet(url);
        return HttpUtil.getResult((HttpRequestBase)httpGet, url, null, null);
    }

    private static String getResult(HttpRequestBase httpRequest, String url, Integer timeOut, Object body) {
        StringBuilder sb = null;
        CloseableHttpResponse response = null;
        CloseableHttpClient httpClient = HttpUtil.getHttpClient(timeOut);
        long start = System.currentTimeMillis();
        try {
            response = httpClient.execute((HttpUriRequest)httpRequest);
            int respCode = response.getStatusLine().getStatusCode();
            if (200 == respCode) {
                HttpEntity entity = response.getEntity();
                sb = new StringBuilder();
                sb.append(EntityUtils.toString((HttpEntity)entity, (String)ENCODING));
                String string = sb.toString();
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884chttp\u8bf7\u6c42\u5f02\u5e38,url={},params={},\u8017\u65f6{}\u79d2,e={}", new Object[]{url, JSON.toJSONString((Object)body), (System.currentTimeMillis() - start) / 1000L, ExceptionUtils.getStackTrace((Throwable)e)});
            throw new RuntimeException("httpUtil\u8bf7\u6c42\u5f02\u5e38", e);
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOGGER.info("http util\u5173\u95ed\u54cd\u5e94\u8fde\u63a5\u51fa\u9519\uff0ce = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                }
            }
        }
        return null;
    }

    private static List<NameValuePair> covertParams2NVPS(Map<String, Object> params) {
        LinkedList<NameValuePair> paramList = new LinkedList<NameValuePair>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            paramList.add((NameValuePair)new BasicNameValuePair(entry.getKey(), entry.getValue().toString()));
        }
        return paramList;
    }

    static {
        try {
            SSLContext sslContext = HttpUtil.getSSLContext(true, null, null);
            Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
            connManager = new PoolingHttpClientConnectionManager(registry);
            connManager.setMaxTotal(2000);
            connManager.setDefaultMaxPerRoute(2000);
            LOGGER.info("\u521d\u59cb\u5316httpclient\u8fde\u63a5\u6c60\u7ba1\u7406\u5668\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("\u521d\u59cb\u5316httpclient\u8fde\u63a5\u6c60\u7ba1\u7406\u5668\u5f02\u5e38,e = {}", (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

