/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util.dingding;

import com.alibaba.fastjson.JSON;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiSnsGetuserinfoBycodeRequest;
import com.dingtalk.api.request.OapiUserGetRequest;
import com.dingtalk.api.request.OapiUserGetUseridByUnionidRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiSnsGetuserinfoBycodeResponse;
import com.dingtalk.api.response.OapiUserGetResponse;
import com.dingtalk.api.response.OapiUserGetUseridByUnionidResponse;
import com.fshows.auth.common.config.property.DingDingProperty;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DingDingClient {
    private static final Logger log = LoggerFactory.getLogger(DingDingClient.class);
    @Autowired
    private DingDingProperty dingDingProperty;

    public String getAccessToken() throws RuntimeException {
        try {
            DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
            OapiGettokenRequest request = new OapiGettokenRequest();
            request.setAppkey(this.dingDingProperty.getMinuteAppKey());
            request.setAppsecret(this.dingDingProperty.getMinuteAppSecret());
            request.setHttpMethod("GET");
            OapiGettokenResponse response = (OapiGettokenResponse)client.execute((TaobaoRequest)request);
            String accessToken = response.getAccessToken();
            return accessToken;
        }
        catch (ApiException e) {
            log.error("getAccessToken failed", (Throwable)e);
            throw new RuntimeException();
        }
    }

    public OapiSnsGetuserinfoBycodeResponse getUserByCode(String code) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/sns/getuserinfo_bycode");
        OapiSnsGetuserinfoBycodeRequest req = new OapiSnsGetuserinfoBycodeRequest();
        req.setTmpAuthCode(code);
        OapiSnsGetuserinfoBycodeResponse response = null;
        try {
            response = (OapiSnsGetuserinfoBycodeResponse)client.execute((TaobaoRequest)req, this.dingDingProperty.getMoveAppKey(), this.dingDingProperty.getMoveAppSecret());
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        System.out.println(JSON.toJSONString(response));
        return response;
    }

    public OapiUserGetUseridByUnionidResponse getUserContactType(String unionid, String token) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/getUseridByUnionid");
        OapiUserGetUseridByUnionidRequest requestParam = new OapiUserGetUseridByUnionidRequest();
        requestParam.setUnionid(unionid);
        requestParam.setHttpMethod("GET");
        OapiUserGetUseridByUnionidResponse response = null;
        try {
            response = (OapiUserGetUseridByUnionidResponse)client.execute((TaobaoRequest)requestParam, token);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        System.out.println(JSON.toJSONString((Object)response));
        return response;
    }

    public OapiUserGetResponse getUserByUserid(String userid, String token) {
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/user/get");
        OapiUserGetRequest request = new OapiUserGetRequest();
        request.setUserid(userid);
        request.setHttpMethod("GET");
        OapiUserGetResponse response = null;
        try {
            response = (OapiUserGetResponse)client.execute((TaobaoRequest)request, token);
        }
        catch (ApiException e) {
            e.printStackTrace();
        }
        return response;
    }
}

