/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.util.dingding;

import com.alibaba.fastjson.JSONObject;
import com.fshows.auth.common.util.HttpUtil;
import com.fshows.auth.common.util.dingding.DingMessage;
import com.fshows.auth.common.util.dingding.DingProperty;
import com.fshows.auth.common.util.dingding.DingSendResult;
import com.fshows.auth.common.util.dingding.DingTextMessage;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@EnableConfigurationProperties(value={DingProperty.class})
public class DingDingMessUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DingDingMessUtil.class);
    public static final String MARKDOWN_WRAP = "\n\n";
    private static DingProperty dingProperty;
    @Resource
    private DingProperty autowiredDingProperty;

    @PostConstruct
    private void initStaticApplicationParams() {
        LOGGER.info("ding params init start ");
        dingProperty = this.autowiredDingProperty;
    }

    public static void sendText(String text) {
        DingDingMessUtil.sendText(text, false, null, "");
    }

    public static void sendText(String text, Object ... args) {
        DingDingMessUtil.sendText(text, false, null, args);
    }

    public static void sendTextAtPhones(String text, List<String> phones) {
        DingDingMessUtil.sendTextAtPhones(text, phones, "");
    }

    public static void sendTextAtPhones(String text, List<String> phones, Object ... args) {
        DingDingMessUtil.sendText(text, false, phones, args);
    }

    public static void sendTextAtAll(String text) {
        DingDingMessUtil.sendTextAtAll(text, "");
    }

    public static void sendTextAtAll(String text, Object ... args) {
        DingDingMessUtil.sendText(text, true, null, args);
    }

    private static void sendText(String text, Boolean atAll, List<String> phones, Object ... args) {
        String msgText = "";
        try {
            DingSendResult result;
            msgText = MessageFormat.format(text, args);
            DingTextMessage message = new DingTextMessage(msgText);
            message.setIsAtAll(atAll);
            if (null != phones && phones.size() > 0) {
                message.setAtMobiles(phones);
            }
            if ((result = DingDingMessUtil.httpSend(dingProperty.getNormalUrl(), message)).isSuccess()) {
                LOGGER.debug(" \u9489\u9489\u673a\u5668\u4eba\u6d88\u606f\u63a8\u9001\u6210\u529f\uff01", (Object)msgText);
            } else {
                LOGGER.error(" \u9489\u9489\u673a\u5668\u4eba\u6d88\u606f\u63a8\u9001\u5931\u8d25\uff01\u6d88\u606f\u5185\u5bb9={},\u9519\u8bef\u7801={},\u9519\u8bef\u5185\u5bb9={}", new Object[]{msgText, result.getErrorCode(), result.getErrorMsg()});
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                LOGGER.error("\u9489\u9489\u673a\u5668\u4eba\u6d88\u606f\u63a8\u9001\u5360\u4f4d\u7b26\u66ff\u6362\u5f02\u5e38\uff01\u6d88\u606f\u5185\u5bb9={},\u5f02\u5e38\u4fe1\u606f={},stack={}", new Object[]{msgText, e.getMessage(), e});
            }
            LOGGER.error("\u9489\u9489\u673a\u5668\u4eba\u6d88\u606f\u63a8\u9001\u5f02\u5e38\uff01\u6d88\u606f\u5185\u5bb9={},\u5f02\u5e38\u4fe1\u606f={},tack={}", new Object[]{msgText, e.getMessage(), e});
        }
    }

    private static DingSendResult httpSend(String webHook, DingMessage message) throws Exception {
        DingSendResult sendResult = new DingSendResult();
        String result = HttpUtil.postJson(webHook, message.toJsonString());
        if (null != result) {
            JSONObject obj = JSONObject.parseObject((String)result);
            Integer errCode = obj.getInteger("errcode");
            sendResult.setErrorCode(errCode);
            sendResult.setErrorMsg(obj.getString("errmsg"));
            sendResult.setIsSuccess(errCode.equals(0));
        }
        return sendResult;
    }
}

