/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.common.mode.result;

import com.fshows.auth.common.enums.SysExceptionEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel
public class Response<T>
implements Serializable {
    private static final long serialVersionUID = -1L;
    @ApiModelProperty(value="\u8bf7\u6c42\u662f\u5426\u6210\u529f", position=0)
    private Boolean success;
    @ApiModelProperty(value="\u8fd4\u56de\u7684\u7684\u6570\u636e", position=2)
    private T data;
    @ApiModelProperty(value="\u9519\u8bef\u4ee3\u7801", position=3)
    private String errorCode;
    @ApiModelProperty(value="\u9519\u8bef\u6d88\u606f", position=4)
    private String errorMsg;

    public Response() {
    }

    public static Response success() {
        CommonResult commonResult = new CommonResult(SysExceptionEnum.OK.getMsg());
        return new Response<CommonResult>(true, commonResult, SysExceptionEnum.OK.getCode(), "");
    }

    public static <T> Response<T> success(T data) {
        return new Response<T>(true, data, SysExceptionEnum.OK.getCode(), "");
    }

    public static <T> Response<T> error(String errorCode, String errorMsg) {
        return new Response<Object>(false, null, errorCode, errorMsg);
    }

    public Response(Boolean success, T data) {
        this.success = success;
        this.data = data;
    }

    public Response(Boolean success, T data, String errorCode, String errorMsg) {
        this.success = success;
        this.data = data;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    static class CommonResult {
        private String message;

        public CommonResult(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

