/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.base.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.fshows.auth.base.datasource.DataSourcePlatFormProperty;
import com.github.pagehelper.PageInterceptor;
import java.sql.SQLException;
import java.util.Properties;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableConfigurationProperties(value={DataSourcePlatFormProperty.class})
@EnableTransactionManagement(proxyTargetClass=true)
@MapperScan(basePackages={"com.fshows.auth.base.dal.mapper"}, sqlSessionFactoryRef="sqlSessionFactory")
public class DataSourcePlatFormConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourcePlatFormConfig.class);
    @Resource
    private DataSourcePlatFormProperty dataSourceProperty;

    @Primary
    @Bean(name={"platFormDataSource"})
    public DataSource platFormDataSource() throws SQLException {
        LOGGER.info("dataSource  build start ");
        DruidDataSource datasource = new DruidDataSource();
        datasource.setUrl(this.dataSourceProperty.getUrl());
        datasource.setDriverClassName(this.dataSourceProperty.getDriverClassName());
        datasource.setUsername(this.dataSourceProperty.getUsername());
        datasource.setPassword(this.dataSourceProperty.getPassword());
        datasource.setInitialSize(this.dataSourceProperty.getInitialSize().intValue());
        datasource.setMinIdle(this.dataSourceProperty.getMinIdle().intValue());
        datasource.setMaxWait((long)this.dataSourceProperty.getMaxWait().intValue());
        datasource.setMaxActive(this.dataSourceProperty.getMaxActive().intValue());
        datasource.setValidationQuery(this.dataSourceProperty.getValidationQuery());
        datasource.setMinEvictableIdleTimeMillis(this.dataSourceProperty.getMinEvictableIdleTimeMillis().longValue());
        datasource.setTimeBetweenEvictionRunsMillis(this.dataSourceProperty.getTimeBetweenEvictionRunsMillis().longValue());
        datasource.setTestWhileIdle(true);
        datasource.setTestOnBorrow(false);
        datasource.setTestOnReturn(false);
        datasource.setFilters("wall");
        LOGGER.info("dataSource  build end ");
        return datasource;
    }

    @Primary
    @Bean(name={"transactionManager"})
    public DataSourceTransactionManager transactionManager(@Qualifier(value="platFormDataSource") DataSource platFormDataSource) {
        return new DataSourceTransactionManager(platFormDataSource);
    }

    @Primary
    @Bean(name={"mysqlPageHelperPlugin"})
    public PageInterceptor buildPageHelperPlugin() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("reasonable", "true");
        properties.setProperty("supportMethodsArguments", "true");
        properties.setProperty("returnPageInfo", "check");
        properties.setProperty("params", "count=countSql");
        pageInterceptor.setProperties(properties);
        return pageInterceptor;
    }

    @Primary
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory(@Qualifier(value="platFormDataSource") DataSource platFormDataSource, @Qualifier(value="mysqlPageHelperPlugin") PageInterceptor pageInterceptor) throws Exception {
        SqlSessionFactoryBean sessionFactoryBean = new SqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(platFormDataSource);
        String path = "classpath*:com/fshows/auth/base/dal/mapper/xml/*.xml";
        sessionFactoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(path));
        sessionFactoryBean.getObject().getConfiguration().addInterceptor((Interceptor)pageInterceptor);
        return sessionFactoryBean.getObject();
    }

    @Bean(name={"sqlSessionTemplate"})
    @Primary
    public SqlSessionTemplate sqlSessionTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

