/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.auth.base.biz.system;

import com.fshows.auth.base.biz.system.UserSystemBiz;
import com.fshows.auth.base.dal.dao.SystemDAO;
import com.fshows.auth.base.dal.dao.UserSystemDAO;
import com.fshows.auth.base.dal.dataobject.SystemDO;
import com.fshows.auth.base.dal.dataobject.UserSystemDO;
import com.fshows.auth.base.dal.resultmap.UserSystemListMap;
import com.fshows.auth.base.request.system.GetUserSystemByUserIdReq;
import com.fshows.auth.base.request.system.RedirectValidateReq;
import com.fshows.auth.base.response.system.GetUserSystemByUserIdRes;
import com.fshows.auth.common.enums.EnumInterface;
import com.fshows.auth.common.enums.exception.SysExceptionEnum;
import com.fshows.auth.common.exception.BusinessException;
import com.fshows.auth.common.mode.result.BasePageModel;
import com.fshows.auth.common.mode.result.BasePageModelResult;
import com.fshows.auth.common.redis.RedisCache;
import com.fshows.auth.common.util.BeanCopierUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserSystemBizImpl
implements UserSystemBiz {
    private static final Logger log = LoggerFactory.getLogger(UserSystemBizImpl.class);
    @Autowired
    private UserSystemDAO userSystemDAO;
    @Autowired
    private SystemDAO systemDAO;
    @Resource
    private RedisCache redisCache;

    @Override
    public BasePageModel getUserSystemList(GetUserSystemByUserIdReq req) {
        PageHelper.startPage((int)req.getPage(), (int)req.getPageSize());
        List<UserSystemListMap> userSystemList = this.userSystemDAO.getUserSystemList(req.getSysName(), req.getUnionId(), req.getSysEnv());
        PageInfo pageInfo = new PageInfo(userSystemList);
        List result = BeanCopierUtil.copyList(userSystemList, GetUserSystemByUserIdRes.class);
        return new BasePageModelResult(pageInfo.getPageNum(), pageInfo.getPageSize(), pageInfo.getTotal(), result);
    }

    @Override
    public void redirectValidate(RedirectValidateReq req) {
        UserSystemDO userSystem = this.userSystemDAO.getUserSystemByCode(req.getSysCode(), req.getUnionId(), req.getSysEnv());
        if (null == userSystem) {
            throw new BusinessException((EnumInterface)SysExceptionEnum.USER_NOT_HAS_PERMISSION, new Object[0]);
        }
        SystemDO system = this.systemDAO.getSystemByCode(req.getSysUrl(), req.getSysCode());
        if (null == system) {
            throw new BusinessException((EnumInterface)SysExceptionEnum.SYSTEM_URL_MODIFIED, new Object[0]);
        }
    }

    @Override
    public void systemLogout(String unionid, String token) {
        try {
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{unionid})) {
                this.redisCache.hdel("fshows.auth.user.unionid", unionid);
            }
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{token})) {
                this.redisCache.hdel("fshows.auth.user.token", token);
            }
        }
        catch (Exception e) {
            log.error("\u8ba4\u8bc1\u4e2d\u5fc3\u9000\u51fa\u767b\u5f55 >>>logout >>> \u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
    }
}

